/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;

import java.util.Set;

class MetadataTypeExclusiveParametersModelAdapter implements ExclusiveParametersModel {

  private final ExclusiveOptionalsTypeAnnotation exclusiveOptionals;

  MetadataTypeExclusiveParametersModelAdapter(ExclusiveOptionalsTypeAnnotation exclusiveOptionals) {
    this.exclusiveOptionals = exclusiveOptionals;
  }

  @Override
  public Set<String> getExclusiveParameterNames() {
    return exclusiveOptionals.getExclusiveParameterNames();
  }

  @Override
  public boolean isOneRequired() {
    return exclusiveOptionals.isOneRequired();
  }
}
