/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseComponentAst;

@Feature(value="Mule Artifact AST")
@Story(value="AST traversal")
public class AstTraversalDirectionTestCase {
    private ComponentAst createComponentAst(ComponentAst ... innerComponents) {
        ComponentAst component = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)component.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        Mockito.when((Object)component.directChildrenStream()).thenAnswer(inv -> Stream.of(innerComponents));
        Mockito.when((Object)component.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return StreamSupport.stream(component.recursiveSpliterator(direction), false);
        });
        Mockito.when((Object)component.recursiveSpliterator()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveSpliterator((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return direction.recursiveSpliterator(component);
        });
        return component;
    }

    private ComponentAst createComponentAstWithComplexParam(ComponentAst ... innerComponents) {
        ComponentAst component = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)component.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        Mockito.when((Object)component.directChildrenStream()).thenReturn(Stream.empty());
        Mockito.when((Object)component.recursiveStream()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveStream((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return StreamSupport.stream(component.recursiveSpliterator(direction), false);
        });
        Mockito.when((Object)component.recursiveSpliterator()).thenCallRealMethod();
        Mockito.when((Object)component.recursiveSpliterator((AstTraversalDirection)ArgumentMatchers.any(AstTraversalDirection.class))).thenAnswer(inv -> {
            AstTraversalDirection direction = (AstTraversalDirection)inv.getArgument(0);
            return direction.recursiveSpliterator(component);
        });
        ArrayType arrayType = (ArrayType)Mockito.mock(ArrayType.class);
        ((ArrayType)Mockito.doAnswer(inv -> {
            ((MetadataTypeVisitor)inv.getArgument(0, MetadataTypeVisitor.class)).visitArrayType((ArrayType)inv.getMock());
            return null;
        }).when((Object)arrayType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        ParameterModel complexParamModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)complexParamModel.getType()).thenReturn((Object)arrayType);
        Mockito.when((Object)complexParamModel.getName()).thenReturn((Object)"complex");
        ComponentParameterAst param = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)param.getModel()).thenReturn((Object)complexParamModel);
        Mockito.when((Object)param.getValue()).thenReturn((Object)Either.right(Arrays.asList(innerComponents)));
        Mockito.when((Object)component.getParameters()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)component.getParameter(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)param);
        return component;
    }

    @Test
    public void singleLevel() {
        ComponentAst child1 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst root = this.createComponentAst(child1, child2);
        ArrayList visitedComponents = new ArrayList();
        root.recursiveStream().forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.TOP_DOWN).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.BOTTOM_UP).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)root)}));
    }

    @Test
    public void twoLevels() {
        ComponentAst child11 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child12 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1 = this.createComponentAst(child11, child12);
        ComponentAst child21 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child22 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(child21, child22);
        ComponentAst root = this.createComponentAst(child1, child2);
        ArrayList visitedComponents = new ArrayList();
        root.recursiveStream().forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child22)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.TOP_DOWN).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child22)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.BOTTOM_UP).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child22), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)root)}));
    }

    @Test
    public void multipleLevels() {
        ComponentAst child11 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child121 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1221 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1222 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child1223 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child122 = this.createComponentAst(child1221, child1222, child1223);
        ComponentAst child12 = this.createComponentAst(child121, child122);
        ComponentAst child1 = this.createComponentAst(child11, child12);
        ComponentAst child21 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(child21);
        ComponentAst child3 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst root = this.createComponentAst(child1, child2, child3);
        ArrayList visitedComponents = new ArrayList();
        root.recursiveStream().forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child121), Matchers.sameInstance((Object)child122), Matchers.sameInstance((Object)child1221), Matchers.sameInstance((Object)child1222), Matchers.sameInstance((Object)child1223), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child3)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.TOP_DOWN).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child121), Matchers.sameInstance((Object)child122), Matchers.sameInstance((Object)child1221), Matchers.sameInstance((Object)child1222), Matchers.sameInstance((Object)child1223), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child3)}));
        visitedComponents.clear();
        root.recursiveStream(AstTraversalDirection.BOTTOM_UP).forEach(visitedComponents::add);
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)child11), Matchers.sameInstance((Object)child121), Matchers.sameInstance((Object)child1221), Matchers.sameInstance((Object)child1222), Matchers.sameInstance((Object)child1223), Matchers.sameInstance((Object)child122), Matchers.sameInstance((Object)child12), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child21), Matchers.sameInstance((Object)child2), Matchers.sameInstance((Object)child3), Matchers.sameInstance((Object)root)}));
    }

    @Test
    @Issue(value="MULE-19636")
    public void recursiveWithHierarchy() {
        ComponentAst child1 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst root = this.createComponentAstWithComplexParam(child1, child2);
        ArrayList visitedComponents = new ArrayList();
        AstTraversalDirection.TOP_DOWN.recursiveStreamWithHierarchy(Stream.of(root), false).forEach(comp -> visitedComponents.add((ComponentAst)comp.getFirst()));
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)root), Matchers.sameInstance((Object)child1), Matchers.sameInstance((Object)child2)}));
    }

    @Test
    @Issue(value="MULE-19636")
    public void recursiveWithHierarchyIgnoreComplex() {
        ComponentAst child1 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst child2 = this.createComponentAst(new ComponentAst[0]);
        ComponentAst root = this.createComponentAstWithComplexParam(child1, child2);
        ArrayList visitedComponents = new ArrayList();
        AstTraversalDirection.TOP_DOWN.recursiveStreamWithHierarchy(Stream.of(root), true).forEach(comp -> visitedComponents.add((ComponentAst)comp.getFirst()));
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.contains((Matcher)Matchers.sameInstance((Object)root)));
    }
}

