/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

/**
 * Provides the {@link org.mule.runtime.api.artifact.ArtifactType}s that may contain an {@link ArtifactAst}, or has configs from
 * which the an {@link ArtifactAst} may be generated.
 */
public enum ArtifactType {

  APPLICATION(org.mule.runtime.api.artifact.ArtifactType.APP),

  DOMAIN(org.mule.runtime.api.artifact.ArtifactType.DOMAIN),

  POLICY(org.mule.runtime.api.artifact.ArtifactType.POLICY),

  MULE_EXTENSION(org.mule.runtime.api.artifact.ArtifactType.MULE_EXTENSION);

  private final org.mule.runtime.api.artifact.ArtifactType actualType;

  ArtifactType(org.mule.runtime.api.artifact.ArtifactType actualType) {
    this.actualType = actualType;
  }

  public org.mule.runtime.api.artifact.ArtifactType getActualType() {
    return actualType;
  }

}
