/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;

/**
 * Provides a way of creating {@link ImportedResource} instances, adding and configuring its attributes.
 *
 * @since 1.0
 */
public interface ImportedResourceBuilder {

  /**
   * Instantiates a new raw builder.
   *
   * @return the newly created builder
   */
  static ImportedResourceBuilder builder() {
    return new DefaultImportedResourceBuilder();
  }

  /**
   * Sets the imported resource name to the builder.
   *
   * @param resourceLocation the resource location.
   * @return the builder with the name set.
   */
  ImportedResourceBuilder withResourceLocation(String resourceLocation);

  /**
   * Sets the imported resource metadata to the builder.
   *
   * @param metadata the component metadata.
   * @return the builder with the metadata set.
   */
  ImportedResourceBuilder withMetadata(ComponentMetadataAst metadata);

  /**
   * Sets the failure caused when resolving this import, if resolution failed.
   * 
   * @param failureMessage a message explaining why the import resolution failed.
   * @return the builder with the metadata set.
   */
  ImportedResourceBuilder withResolutionFailure(String failureMessage);

  /**
   * Builds the target imported resource.
   *
   * @return the target imported resource.
   */
  ImportedResource build();

}
