/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.MetadataTypeObjectFieldTypeAdapter;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.internal.meta.model.DefaultTypeAnnotationModelPropertyWrapper;

class ObjectFieldTypeAsParameterModelAdapter
implements MetadataTypeObjectFieldTypeAdapter,
ParameterModel {
    private static final ParameterDslConfiguration DSL_CONFIG = ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build();
    private final ObjectFieldType wrappedFieldType;
    private final Map<Class<? extends ModelProperty>, ModelProperty> modelProperties = new LinkedHashMap<Class<? extends ModelProperty>, ModelProperty>();
    private final LayoutModel layoutModel;

    public ObjectFieldTypeAsParameterModelAdapter(ObjectFieldType wrappedFieldType, Optional<QName> ownerCustomQName) {
        this.wrappedFieldType = wrappedFieldType;
        ownerCustomQName.map(qName -> new QNameModelProperty(new QName(qName.getNamespaceURI(), wrappedFieldType.getKey().getName().getLocalPart(), qName.getPrefix()))).ifPresent(qnmp -> this.modelProperties.put(qnmp.getClass(), (ModelProperty)qnmp));
        this.wrappedFieldType.getAnnotation(DefaultTypeAnnotationModelPropertyWrapper.class).ifPresent(ann -> {
            ModelProperty mp = ann.asModelProperty();
            this.modelProperties.put(mp.getClass(), mp);
        });
        Optional optionalLayoutTypeAnnotation = this.wrappedFieldType.getAnnotation(LayoutTypeAnnotation.class);
        if (optionalLayoutTypeAnnotation.isPresent()) {
            LayoutTypeAnnotation layoutTypeAnnotation = (LayoutTypeAnnotation)optionalLayoutTypeAnnotation.get();
            LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
            if (layoutTypeAnnotation.isText()) {
                layoutModelBuilder.asText();
            }
            if (layoutTypeAnnotation.isPassword()) {
                layoutModelBuilder.asPassword();
            }
            if (layoutTypeAnnotation.isQuery()) {
                layoutModelBuilder.asQuery();
            }
            layoutTypeAnnotation.getOrder().ifPresent(arg_0 -> ((LayoutModel.LayoutModelBuilder)layoutModelBuilder).order(arg_0));
            layoutTypeAnnotation.getTabName().ifPresent(arg_0 -> ((LayoutModel.LayoutModelBuilder)layoutModelBuilder).tabName(arg_0));
            this.layoutModel = layoutModelBuilder.build();
        } else {
            this.layoutModel = null;
        }
    }

    public String getName() {
        return this.wrappedFieldType.getKey().getName().getLocalPart();
    }

    public String getDescription() {
        return this.wrappedFieldType.getKey().getDescription().orElse(null);
    }

    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        Objects.requireNonNull(propertyType);
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new LinkedHashSet<ModelProperty>(this.modelProperties.values()));
    }

    public MetadataType getType() {
        return this.wrappedFieldType.getValue();
    }

    public boolean hasDynamicType() {
        return false;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return this.wrappedFieldType.getAnnotation(DisplayTypeAnnotation.class).flatMap(DisplayTypeAnnotation::getPathModel).map(pm -> DisplayModel.builder().path(pm).build());
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public boolean isRequired() {
        return this.wrappedFieldType.isRequired();
    }

    public boolean isOverrideFromConfig() {
        return false;
    }

    public ExpressionSupport getExpressionSupport() {
        return this.wrappedFieldType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.SUPPORTED);
    }

    public Object getDefaultValue() {
        return this.wrappedFieldType.getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue).orElseGet(() -> this.wrappedFieldType.getValue().getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue).orElse(null));
    }

    public ParameterDslConfiguration getDslConfiguration() {
        return DSL_CONFIG;
    }

    public ParameterRole getRole() {
        return this.getLayoutModel().map(lyt -> lyt.isText() ? ParameterRole.CONTENT : ParameterRole.BEHAVIOUR).orElse(ParameterRole.BEHAVIOUR);
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.wrappedFieldType.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElseGet(() -> this.wrappedFieldType.getValue().getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()));
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.empty();
    }

    public List<FieldValueProviderModel> getFieldValueProviderModels() {
        return Collections.emptyList();
    }

    public boolean isComponentId() {
        return this.getName().equals("name");
    }

    @Override
    public boolean isWrapperFor(ObjectFieldType fieldType) {
        return this.wrappedFieldType.equals(fieldType);
    }

    public String toString() {
        return "ObjectFieldTypeAsParameterModelAdapter{" + this.wrappedFieldType.toString() + "}";
    }

    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.empty();
    }
}

