/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

public final class CompositeErrorTypeRepository
implements ErrorTypeRepository {
    private final List<ErrorTypeRepository> children;

    public CompositeErrorTypeRepository(List<ErrorTypeRepository> children) {
        this.children = children;
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        for (ErrorTypeRepository child : this.children) {
            Optional lookupErrorType = child.lookupErrorType(errorTypeComponentIdentifier);
            if (!lookupErrorType.isPresent()) continue;
            return lookupErrorType;
        }
        return Optional.empty();
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        return this.children.stream().map(child -> child.getErrorType(errorTypeIdentifier)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Collection<String> getErrorNamespaces() {
        return this.children.stream().flatMap(c -> c.getErrorNamespaces().stream()).collect(Collectors.toSet());
    }

    public ErrorType getAnyErrorType() {
        return this.children.stream().map(ErrorTypeRepository::getAnyErrorType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public ErrorType getSourceErrorType() {
        return this.children.stream().map(ErrorTypeRepository::getSourceErrorType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public ErrorType getSourceResponseErrorType() {
        return this.children.stream().map(ErrorTypeRepository::getSourceResponseErrorType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public ErrorType getCriticalErrorType() {
        return this.children.stream().map(ErrorTypeRepository::getCriticalErrorType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Set<ErrorType> getErrorTypes() {
        return this.children.stream().flatMap(repo -> repo.getErrorTypes().stream()).collect(Collectors.toSet());
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return this.children.stream().flatMap(repo -> repo.getInternalErrorTypes().stream()).collect(Collectors.toSet());
    }
}

