/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;

public class LightComponentAstBuilderTestCase {

  @Rule
  public final MockitoRule mockitoRule = MockitoJUnit.rule();

  private LightComponentAstBuilder builder;
  @Mock
  private PropertiesResolver propertiesResolver;
  @Mock
  private ParameterModelUtils parameterModelUtils;
  @Mock
  private NestableElementModel elementModel;
  @Mock
  private ComponentModel componentModel;
  @Mock
  private ConnectionProviderModel providerModel;
  @Mock
  private ConfigurationModel configurationModel;

  @Before
  public void setUp() throws Exception {
    builder = new LightComponentAstBuilder(propertiesResolver, parameterModelUtils);
  }

  @Test
  public void addChildComponent() {
    builder.addChildComponent();
    assertThat(builder.get().directChildren().size(), is(1));
  }

  @Test
  public void builderMethodsReturnBuilder() {
    assertThat(builder.withNestableElementModel(elementModel), is(builder));
    assertThat(builder.withComponentModel(componentModel), is(builder));
    assertThat(builder.withConfigurationModel(configurationModel), is(builder));
    assertThat(builder.withConnectionProviderModel(providerModel), is(builder));
  }
}
