/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.api.builder;

import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.ARTIFACT_AST;
import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.AstConstruction.ARTIFACT_AST_CONSTRUCTION;

import static java.util.Collections.emptySet;
import static java.util.Optional.empty;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.mock;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;

import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(ARTIFACT_AST)
@Story(ARTIFACT_AST_CONSTRUCTION)
public class ArtifactAstBuilderTestCase {

  @Test
  public void buildEmpty() {
    final ArtifactAst artifact = ArtifactAstBuilder.builder(emptySet(), empty()).build();
    assertThat(artifact.topLevelComponentsStream().count(), is(0L));
    assertThat(artifact.recursiveStream().count(), is(0L));
  }

  @Test
  public void buildWithChildren() {
    final ArtifactAstBuilder builder = ArtifactAstBuilder.builder(emptySet(), empty());

    builder.addTopLevelComponent()
        .withIdentifier(ComponentIdentifier.builder().namespace("ns").name("topLevel1").build())
        .withParameterizedModel(mock(ParameterizedModel.class))
        .withMetadata(DefaultComponentMetadataAst.builder().build());
    builder.addTopLevelComponent()
        .withIdentifier(ComponentIdentifier.builder().namespace("ns").name("topLevel2").build())
        .withParameterizedModel(mock(ParameterizedModel.class))
        .withMetadata(DefaultComponentMetadataAst.builder().build())
        .addChildComponent()
        .withIdentifier(ComponentIdentifier.builder().namespace("ns").name("child").build())
        .withParameterizedModel(mock(ParameterizedModel.class))
        .withMetadata(DefaultComponentMetadataAst.builder().build());

    final ArtifactAst artifact = builder.build();

    assertThat(artifact.topLevelComponentsStream().count(), is(2L));
    assertThat(artifact.recursiveStream().count(), is(3L));
  }
}
