/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.api.validation;

import static org.mule.runtime.ast.api.validation.ImportValidationConstants.IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_PATTERN;
import static org.mule.runtime.ast.api.validation.ImportValidationConstants.IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_TEMPLATE;
import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.ARTIFACT_AST;
import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.Validations.VALIDATIONS;

import static java.lang.String.format;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(ARTIFACT_AST)
@Story(VALIDATIONS)
public class ImportValidationConstantsTestCase {

  @Test
  public void patternMatchesTemplateMessage() {
    String message = format(IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_TEMPLATE, "resource-name.&*(", "mule", "domain");

    assertThat("pattern not matched",
               IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_PATTERN.matcher(message).matches(), is(true));
  }

  @Test
  public void patternNotMatchesNonTemplateMessage() {
    String message = "randomString";

    assertThat("pattern matched",
               IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_PATTERN.matcher(message).matches(), is(false));
  }
}
