/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ApplicationModelTypeUtils;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.sdk.api.stereotype.MuleStereotypes;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ApplicationModelTypeUtilsTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mockns").setNamespace("http://mockns").build();
    private static final ComponentIdentifier CONFIG = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-config").build();
    private static final ComponentIdentifier CONN_PROVIDER = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-connection-provider").build();
    private static final ComponentIdentifier CONSTRUCT_CONFIG = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("construct-config").build();
    private static final ComponentIdentifier OPERATION = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-operation").build();
    private static final ComponentIdentifier SOURCE = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-source").build();
    private static final ComponentIdentifier SHOW_IN_DSL_GROUP = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("param-group-in-dsl").build();
    private static final ComponentIdentifier SIMPLE_POJO_PARAM_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-pojo-param").build();
    private static final ComponentIdentifier SIMPLE_POJO_PARAM_EXPRESSION_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-pojo-param-expression").build();
    private static final ComponentIdentifier SIMPLE_POJO_PARAM_IN_DSL_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-pojo-param-in-dsl").build();
    private static final ComponentIdentifier SIMPLE_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-pojo").build();
    private static final ComponentIdentifier SIMPLE_TEXT_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-text-pojo").build();
    private static final ComponentIdentifier SIMPLE_EXTENSIBLE_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple-extensible-pojo").build();
    private static final ComponentIdentifier SIMPLE_SCHEDULER_POJO_ID = ComponentIdentifier.builder().namespaceUri("http://www.mulesoft.org/schema/mule/core").namespace("mule").name("scheduling-strategy").build();
    private static final ComponentIdentifier SIMPLE_TEXT_PARAM_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("pojo-text-param").build();
    private static final ComponentIdentifier COMPLEX_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("complex-pojo").build();
    private static final ComponentIdentifier LIST_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("list-pojo").build();
    private static final ComponentIdentifier LIST_TEXT_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("list-text-pojo").build();
    private static final ComponentIdentifier SIMPLES_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simples").build();
    private static final ComponentIdentifier MAP_POJO_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("map-pojo").build();
    private static final ComponentIdentifier SIMPLES_BY_KEY_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("by-key-simples").build();
    private static final ComponentIdentifier SIMPLE_BY_KEY_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("by-key-simple").build();
    private static final ComponentIdentifier MAP_STRING_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("map-string").build();
    private static final ComponentIdentifier STRINGS_BY_KEY_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("by-key-strings").build();
    private static final ComponentIdentifier STRING_BY_KEY_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("by-key-string").build();
    private static final ComponentIdentifier SIMPLE_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("simple").build();
    private static final ComponentIdentifier WRAPPER_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("wrapper").build();
    private static final ComponentIdentifier LIST_OF_ROUTES_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("list-of-routes").build();
    private static final ComponentIdentifier ITEM_ROUTER = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("item-router").build();
    @Rule
    public final TestName testName = new TestName();
    private ExtensionModel extensionModel;
    private OperationModel operationModel;
    private NestedRouteModel nestedComponentModel;
    private SourceModel sourceModel;
    private DefaultExtensionModelHelper extModelHelper;
    private DefaultComponentAstBuilder mockParentAstBuilder;

    @Before
    public void before() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(ApplicationModelTypeUtilsTestCase.class.getClassLoader());
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        this.operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        this.nestedComponentModel = (NestedRouteModel)Mockito.mock(NestedRouteModel.class);
        Mockito.when((Object)this.nestedComponentModel.getMaxOccurs()).thenReturn(Optional.of(Integer.MAX_VALUE));
        List<NestableElementModel> nestedComponents = Collections.singletonList((NestableElementModel)Mockito.mock(NestableElementModel.class));
        Mockito.when((Object)this.nestedComponentModel.getNestedComponents()).thenReturn(nestedComponents);
        this.sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        ComponentIdentifier parentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"parent");
        this.mockParentAstBuilder = (DefaultComponentAstBuilder)Mockito.mock(DefaultComponentAstBuilder.class);
        Mockito.when((Object)this.mockParentAstBuilder.getIdentifier()).thenReturn((Object)parentIdentifier);
        MetadataType paramType = typeLoader.load(this.getParamType());
        ParameterGroupModel paramGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        ParameterGroupModel paramGroupInDsl = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        String paramName = "simplePojoParam";
        String paramExpressionName = "simplePojoParamExpression";
        String paramNameInDsl = "simplePojoParamInDsl";
        ParameterModel simplePojoParam = this.createParameter(paramType, "simplePojoParam");
        ParameterModel simplePojoParamExpression = this.createOnlyExpressionParameter(paramType, "simplePojoParamExpression");
        ParameterModel simplePojoParamInDsl = this.createParameter(paramType, "simplePojoParamInDsl");
        Mockito.when((Object)paramGroup.getParameter("simplePojoParam")).thenReturn(Optional.of(simplePojoParam));
        Mockito.when((Object)paramGroup.getParameter("simplePojoParamExpression")).thenReturn(Optional.of(simplePojoParamExpression));
        Mockito.when((Object)paramGroup.getParameterModels()).thenReturn(Arrays.asList(simplePojoParam, simplePojoParamExpression));
        Mockito.when((Object)paramGroup.getName()).thenReturn((Object)"paramGroup");
        Mockito.when((Object)paramGroupInDsl.getName()).thenReturn((Object)"paramGroupInDsl");
        Mockito.when((Object)paramGroupInDsl.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)paramGroupInDsl.getName()).thenReturn((Object)"paramGroupInDsl");
        Mockito.when((Object)paramGroupInDsl.getParameter("simplePojoParamInDsl")).thenReturn(Optional.of(simplePojoParamInDsl));
        Mockito.when((Object)paramGroupInDsl.getParameterModels()).thenReturn(Collections.singletonList(simplePojoParamInDsl));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"simpleOperation");
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(paramGroup, paramGroupInDsl));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(simplePojoParam, simplePojoParamExpression, simplePojoParamInDsl));
        Mockito.when((Object)this.nestedComponentModel.getName()).thenReturn((Object)"listOfRoutesRouter");
        SourceCallbackModel sourceSuccessCallbackModel = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)sourceSuccessCallbackModel.getParameterGroupModels()).thenReturn(Arrays.asList(paramGroup, paramGroupInDsl));
        Mockito.when((Object)sourceSuccessCallbackModel.getAllParameterModels()).thenReturn(Arrays.asList(simplePojoParam, simplePojoParamExpression, simplePojoParamInDsl));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"simpleSource");
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(sourceSuccessCallbackModel));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Arrays.asList(simplePojoParam, simplePojoParamExpression, simplePojoParamInDsl));
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"mockExtension");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getOperationModel("simpleOperation")).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.extensionModel.getSourceModel("simpleSource")).thenReturn(Optional.of(this.sourceModel));
        Mockito.when((Object)this.extensionModel.getTypes()).thenReturn(new HashSet<ObjectType>(Arrays.asList((ObjectType)paramType, (ObjectType)typeLoader.load(SimpleTextPojo.class), (ObjectType)typeLoader.load(ComplexPojo.class), (ObjectType)typeLoader.load(ListPojo.class), (ObjectType)typeLoader.load(ListTextPojo.class), (ObjectType)typeLoader.load(MapPojo.class), (ObjectType)typeLoader.load(MapString.class))));
        this.extModelHelper = (DefaultExtensionModelHelper)Mockito.spy((Object)new DefaultExtensionModelHelper(Collections.singleton(this.extensionModel)));
        ((DefaultExtensionModelHelper)Mockito.doAnswer(inv -> {
            ComponentIdentifier identifier = (ComponentIdentifier)inv.getArgument(0);
            ExtensionModelHelper.ExtensionWalkerModelDelegate walker = (ExtensionModelHelper.ExtensionWalkerModelDelegate)inv.getArgument(2);
            if (identifier.equals(CONFIG)) {
                ConfigurationModel configModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
                Mockito.when((Object)configModel.getName()).thenReturn((Object)"simpleConfig");
                walker.onConfiguration(configModel);
            } else if (identifier.equals(CONN_PROVIDER)) {
                ConnectionProviderModel connProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
                Mockito.when((Object)connProviderModel.getName()).thenReturn((Object)"simpleConnectionProvider");
                walker.onConnectionProvider(connProviderModel);
            } else if (identifier.equals(CONSTRUCT_CONFIG)) {
                ConstructModel configModel = (ConstructModel)Mockito.mock(ConstructModel.class);
                Mockito.when((Object)configModel.getName()).thenReturn((Object)"constructConfig");
                Mockito.when((Object)configModel.getStereotype()).thenReturn((Object)MuleStereotypes.CONFIG);
                walker.onConstruct(configModel);
            } else if (identifier.equals(OPERATION)) {
                walker.onOperation(this.operationModel);
            } else if (identifier.equals(SOURCE)) {
                walker.onSource(this.sourceModel);
            } else if (identifier.equals(SIMPLE_POJO_ID)) {
                walker.onType(paramType);
            } else if (identifier.equals(SIMPLE_TEXT_POJO_ID)) {
                walker.onType(typeLoader.load(SimpleTextPojo.class));
            } else if (identifier.equals(COMPLEX_POJO_ID)) {
                walker.onType(typeLoader.load(ComplexPojo.class));
            } else if (identifier.equals(LIST_POJO_ID)) {
                walker.onType(typeLoader.load(ListPojo.class));
            } else if (identifier.equals(LIST_TEXT_POJO_ID)) {
                walker.onType(typeLoader.load(ListTextPojo.class));
            } else if (identifier.equals(MAP_POJO_ID)) {
                walker.onType(typeLoader.load(MapPojo.class));
            } else if (identifier.equals(MAP_STRING_ID)) {
                walker.onType(typeLoader.load(MapString.class));
            } else if (identifier.equals(SIMPLE_ID)) {
                walker.onType(paramType);
            } else if (identifier.equals(LIST_OF_ROUTES_ID)) {
                walker.onNestableElement((NestableElementModel)this.nestedComponentModel);
            }
            return null;
        }).when((Object)this.extModelHelper)).walkToComponent((ComponentIdentifier)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (ExtensionModelHelper.ExtensionWalkerModelDelegate)ArgumentMatchers.any(), (ExtensionModel)ArgumentMatchers.eq((Object)this.extensionModel));
    }

    private Type getParamType() {
        String methodName = this.testName.getMethodName();
        if (methodName.contains("WrappedParam")) {
            return SimpleExtensiblePojo.class;
        }
        return SimplePojo.class;
    }

    private ParameterModel createParameter(MetadataType paramType, String paramName) {
        ParameterModel simplePojoParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)simplePojoParam.getName()).thenReturn((Object)paramName);
        Mockito.when((Object)simplePojoParam.getType()).thenReturn((Object)paramType);
        Mockito.when((Object)simplePojoParam.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)simplePojoParam.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        return simplePojoParam;
    }

    private ParameterModel createOnlyExpressionParameter(MetadataType paramType, String paramName) {
        ParameterModel simplePojoParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)simplePojoParam.getName()).thenReturn((Object)paramName);
        Mockito.when((Object)simplePojoParam.getType()).thenReturn((Object)paramType);
        Mockito.when((Object)simplePojoParam.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)simplePojoParam.getExpressionSupport()).thenReturn((Object)ExpressionSupport.REQUIRED);
        Mockito.when((Object)simplePojoParam.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        return simplePojoParam;
    }

    @Test
    public void simpleParamInSimplePojo() {
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value")));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void simpleTextParamInSimpleTextPojo() {
        DefaultComponentAstBuilder textComponent = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_PARAM_POJO_ID, Collections.emptyMap(), "myTextBody"));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_POJO_ID, Collections.emptyMap(), Collections.singletonList(textComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoTextParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimpleTextPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void simpleScheduler() {
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_SCHEDULER_POJO_ID, Collections.emptyMap(), "schedulerStrategy"));
        component.withExtensionModel(this.extensionModel);
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component, (VerificationMode)Mockito.atLeastOnce())).getGenerationInformation();
    }

    @Test
    @Issue(value="MULE-19571")
    public void simpleTextParamInSimpleTextPojoInArray() {
        DefaultComponentAstBuilder textComponent = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_PARAM_POJO_ID, Collections.emptyMap(), "myTextBody"));
        DefaultComponentAstBuilder item = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_POJO_ID, Collections.emptyMap(), Collections.singletonList(textComponent)));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_ID, Collections.emptyMap(), Collections.singletonList(item)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_TEXT_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)item)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoTextParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimpleTextPojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("myTextBody")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.of(SIMPLE_TEXT_PARAM_POJO_ID))));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)item)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void simpleEmptyTextParamInSimpleTextPojo() {
        DefaultComponentAstBuilder textComponent = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_PARAM_POJO_ID, Collections.emptyMap(), Collections.emptyList()));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_POJO_ID, Collections.emptyMap(), Collections.singletonList(textComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoTextParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimpleTextPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void simpleEmptyCDataTextParamInSimpleTextPojo() {
        DefaultComponentAstBuilder textComponentBuilder = this.createModel(SIMPLE_TEXT_PARAM_POJO_ID, Collections.emptyMap(), Collections.emptyList());
        textComponentBuilder.withMetadata(DefaultComponentMetadataAst.builder().putParserAttribute("IS_CDATA", (Object)true).build());
        DefaultComponentAstBuilder textComponent = (DefaultComponentAstBuilder)Mockito.spy((Object)textComponentBuilder);
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_TEXT_POJO_ID, Collections.emptyMap(), Collections.singletonList(textComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoTextParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimpleTextPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoParamInComplexPojo() {
        DefaultComponentAstBuilder innerComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(COMPLEX_POJO_ID, Collections.emptyMap(), Collections.singletonList(innerComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simple")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("ComplexPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoParamsInListPojo() {
        DefaultComponentAstBuilder innerComponent1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1"))));
        DefaultComponentAstBuilder innerComponent2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2"))));
        DefaultComponentAstBuilder innerComponent3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3"))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_ID, Collections.emptyMap(), Arrays.asList(innerComponent1, innerComponent2, innerComponent3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value1")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value2")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simples")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("ListPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-19602")
    public void pojoParamsGroupsInListPojo() {
        DefaultComponentAstBuilder innerComponent1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1"))));
        DefaultComponentAstBuilder innerComponent2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2"))));
        DefaultComponentAstBuilder innerComponent3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3"))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_ID, Collections.emptyMap(), Arrays.asList(innerComponent1, innerComponent2, innerComponent3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value1")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value2")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoListParamsGroupsInListPojo() {
        DefaultComponentAstBuilder innerComponent1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1"))));
        DefaultComponentAstBuilder innerComponent2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2"))));
        DefaultComponentAstBuilder innerComponent3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3"))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_ID, Collections.emptyMap(), Arrays.asList(innerComponent1, innerComponent2, innerComponent3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value1")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value2")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoNestedListParamsGroupsInListPojo() {
        DefaultComponentAstBuilder innerComponent1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1"))));
        DefaultComponentAstBuilder innerComponent2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2"))));
        DefaultComponentAstBuilder innerComponent3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3"))));
        DefaultComponentAstBuilder innerListComponent = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_POJO_ID, Collections.emptyMap(), Collections.singletonList(innerComponent1)));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_ID, Collections.emptyMap(), Arrays.asList(innerComponent2, innerListComponent, innerComponent3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoParamsInMapPojo() {
        DefaultComponentAstBuilder innerComponent1 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1")));
        DefaultComponentAstBuilder innerComponent2 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2")));
        DefaultComponentAstBuilder innerComponent3 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3")));
        DefaultComponentAstBuilder entry1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "1"), Collections.singletonList(innerComponent1))));
        DefaultComponentAstBuilder entry2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "2"), Collections.singletonList(innerComponent2))));
        DefaultComponentAstBuilder entry3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "3"), Collections.singletonList(innerComponent3))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_BY_KEY_ID, Collections.emptyMap(), Arrays.asList(entry1, entry2, entry3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(MAP_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value1")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value2")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("byKeySimples")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("MapPojo")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)component)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-19602")
    public void pojoParamsGroupsInMapPojo() {
        DefaultComponentAstBuilder innerComponent1 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value1")));
        DefaultComponentAstBuilder innerComponent2 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value2")));
        DefaultComponentAstBuilder innerComponent3 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value3")));
        DefaultComponentAstBuilder entry1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "1"), Collections.singletonList(innerComponent1))));
        DefaultComponentAstBuilder entry2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "2"), Collections.singletonList(innerComponent2))));
        DefaultComponentAstBuilder entry3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, Collections.singletonMap("key", "3"), Collections.singletonList(innerComponent3))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLES_BY_KEY_ID, Collections.emptyMap(), Arrays.asList(entry1, entry2, entry3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(MAP_POJO_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value1")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value2")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value3")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)innerComponent3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-19655")
    public void stringEntriesInMap() {
        DefaultComponentAstBuilder entry1 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(STRING_BY_KEY_ID, this.keyValueMap("1", "value1"))));
        DefaultComponentAstBuilder entry2 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(STRING_BY_KEY_ID, this.keyValueMap("2", "value2"))));
        DefaultComponentAstBuilder entry3 = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(STRING_BY_KEY_ID, this.keyValueMap("3", "value3"))));
        DefaultComponentAstBuilder wrapper = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(STRINGS_BY_KEY_ID, Collections.emptyMap(), Arrays.asList(entry1, entry2, entry3)));
        DefaultComponentAstBuilder component = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(MAP_STRING_ID, Collections.emptyMap(), Collections.singletonList(wrapper)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)component, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry1)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("key")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry1)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("value")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry1)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry2)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("key")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry2)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("value")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry2)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry3)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("key")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry3)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("value")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("General")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)entry3)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
    }

    @Test
    public void pojoParamInOperation() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simplePojoParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("paramGroup")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterNestedValueModelMatcher(paramComponent)), (Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContaining.hasItem((Object)SIMPLE_POJO_PARAM_ID)));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).withComponentModel((ComponentModel)this.operationModel);
    }

    @Test
    @Issue(value="MULE-19566")
    public void pojoExpressionParamInOperation() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_EXPRESSION_ID, Collections.emptyMap(), "#['pojoSimpleParam': 'value']")));
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).addParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simplePojoParamExpression")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("paramGroup")), (Consumer)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).withComponentModel((ComponentModel)this.operationModel);
    }

    @Test
    public void pojoParamGroupShowInDslInOperation() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_IN_DSL_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder group = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SHOW_IN_DSL_GROUP, Collections.emptyMap(), Arrays.asList(paramComponent)));
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Arrays.asList(group)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simplePojoParamInDsl")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("paramGroupInDsl")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterNestedValueModelMatcher(paramComponent)), (Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContaining.hasItem((Object)SIMPLE_POJO_PARAM_IN_DSL_ID)));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).withComponentModel((ComponentModel)this.operationModel);
    }

    @Test
    @Issue(value="MULE-17711")
    @io.qameta.allure.Description(value="DSL groups are removed from the child list when a param form the group is handled")
    public void pojoParamGroupShowInDslInOperationNoGroupAsChild() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_IN_DSL_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder group = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SHOW_IN_DSL_GROUP, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Collections.singletonList(group)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        operation.prepareForBuild();
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void pojoParamGroupShowInDslInOperationWithParameterGroup() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_IN_DSL_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder group = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SHOW_IN_DSL_GROUP, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        group.withRawParameter("simplePojoParamInDsl", "Stoat");
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Collections.singletonList(group)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        operation.prepareForBuild();
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)0L));
    }

    @Test(expected=MuleRuntimeException.class)
    public void pojoParamGroupWithParameterGroupCycle() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_IN_DSL_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder group = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SHOW_IN_DSL_GROUP, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        group.withRawParameter("simplePojoParamInDsl", "Stoat");
        DefaultComponentAstBuilder component = this.createModel(OPERATION, Collections.emptyMap(), Collections.singletonList(group));
        component.addChildComponent((BaseComponentAstBuilder)paramComponent);
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)component);
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
    }

    @Test
    public void removeChildMapFromPojo() {
        DefaultComponentAstBuilder entryComponent1 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, this.keyValueMap("firstKey", "firstValue")));
        DefaultComponentAstBuilder entryComponent2 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, this.keyValueMap("secondKey", "secondValue")));
        ParameterModel mapParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultComponentAstBuilder operation = this.createOperationWithMapParameter(entryComponent1, entryComponent2, mapParameterModel);
        Mockito.when((Object)mapParameterModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(new NoWrapperModelProperty()));
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)2L));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).removeChildComponent((BaseComponentAstBuilder)entryComponent1);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)operation)).removeChildComponent((BaseComponentAstBuilder)entryComponent2);
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)0L));
    }

    private DefaultComponentAstBuilder createOperationWithMapParameter(DefaultComponentAstBuilder entryComponent1, DefaultComponentAstBuilder entryComponent2, ParameterModel mapParameterModel) {
        DefaultComponentAstBuilder operation = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(OPERATION, Collections.emptyMap(), Arrays.asList(entryComponent1, entryComponent2)));
        Mockito.when((Object)mapParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)mapParameterModel.getName()).thenReturn((Object)"mapEntries");
        Mockito.when((Object)mapParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        ParameterDslConfiguration dslConfig = (ParameterDslConfiguration)Mockito.mock(ParameterDslConfiguration.class);
        Mockito.when((Object)dslConfig.allowsReferences()).thenReturn((Object)true);
        Mockito.when((Object)dslConfig.allowsInlineDefinition()).thenReturn((Object)true);
        Mockito.when((Object)mapParameterModel.getDslConfiguration()).thenReturn((Object)dslConfig);
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(ApplicationModelTypeUtilsTestCase.class.getClassLoader());
        MetadataType stringType = typeLoader.load(String.class);
        DefaultObjectType mapType = new DefaultObjectType(new ArrayList(), true, stringType, MetadataFormat.JSON, new HashMap()){

            public <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> extension) {
                if (extension.equals(ClassInformationAnnotation.class)) {
                    return Optional.of(new ClassInformationAnnotation(Map.class));
                }
                return Optional.empty();
            }
        };
        Mockito.when((Object)mapParameterModel.getType()).thenReturn((Object)mapType);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)"paramGroup");
        Mockito.when((Object)parameterGroupModel.getParameter("mapEntries")).thenReturn(Optional.of(mapParameterModel));
        Mockito.when((Object)parameterGroupModel.getParameterModels()).thenReturn(Collections.singletonList(mapParameterModel));
        List originalGroups = this.operationModel.getParameterGroupModels();
        ArrayList<ParameterGroupModel> newGroups = new ArrayList<ParameterGroupModel>(originalGroups);
        newGroups.add(parameterGroupModel);
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(newGroups);
        List originalParams = this.operationModel.getAllParameterModels();
        ArrayList<ParameterModel> newParams = new ArrayList<ParameterModel>(originalParams);
        newParams.add(mapParameterModel);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(newParams);
        return operation;
    }

    @Test
    public void doNotRemoveChildMapFromWrappedPojo() {
        DefaultComponentAstBuilder entryComponent1 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, this.keyValueMap("firstKey", "firstValue")));
        DefaultComponentAstBuilder entryComponent2 = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_BY_KEY_ID, this.keyValueMap("secondKey", "secondValue")));
        ParameterModel mapParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultComponentAstBuilder operation = this.createOperationWithMapParameter(entryComponent1, entryComponent2, mapParameterModel);
        Mockito.when((Object)mapParameterModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.empty());
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)2L));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)operation, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)operation.childComponentsStream().count(), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void pojoParamInSourceCallback() {
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_POJO_PARAM_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder source = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SOURCE, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)source, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("pojoSimpleParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("SimplePojo")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterRawValueModelMatcher("value")), (Optional)MockitoHamcrest.argThat((Matcher)Is.is(Optional.empty())));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).withParameterizedModel((ParameterizedModel)ArgumentMatchers.any());
        ((DefaultComponentAstBuilder)Mockito.verify((Object)source)).withParameter((ParameterModel)MockitoHamcrest.argThat((Matcher)new ParameterModelMatcher("simplePojoParam")), (ParameterGroupModel)MockitoHamcrest.argThat((Matcher)new ParameterGroupValueModelMatcher("paramGroup")), (ComponentParameterAst)MockitoHamcrest.argThat((Matcher)new ParameterNestedValueModelMatcher(paramComponent)), (Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContaining.hasItem((Object)SIMPLE_POJO_PARAM_ID)));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)source)).withComponentModel((ComponentModel)this.sourceModel);
    }

    @Test
    public void pojoWrappedParamInCallback() {
        DefaultComponentAstBuilder paramChild = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SIMPLE_EXTENSIBLE_POJO_ID, Collections.singletonMap("pojoSimpleParam", "value"))));
        DefaultComponentAstBuilder model = this.createModel(SIMPLE_POJO_PARAM_ID, Collections.singletonMap("pojoSimpleParam", "value"));
        model.addChildComponent((BaseComponentAstBuilder)paramChild);
        DefaultComponentAstBuilder paramComponent = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)model));
        DefaultComponentAstBuilder source = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(SOURCE, Collections.emptyMap(), Collections.singletonList(paramComponent)));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)source, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        ((DefaultComponentAstBuilder)Mockito.verify((Object)paramComponent)).childComponentsStream();
        ((DefaultComponentAstBuilder)Mockito.verify((Object)source)).withParameter((ParameterModel)ArgumentMatchers.any(), (ParameterGroupModel)ArgumentMatchers.any(), (ComponentParameterAst)ArgumentMatchers.any(), (Iterable)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-19744")
    public void configComponentType() {
        DefaultComponentAstBuilder config = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(CONFIG, Collections.emptyMap()));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)config, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)config.getComponentType(), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    @Issue(value="MULE-19744")
    public void connectionProviderComponentType() {
        DefaultComponentAstBuilder connProvider = this.buildOnce((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(CONN_PROVIDER, Collections.emptyMap())));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)connProvider, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)connProvider.getComponentType(), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.CONNECTION));
    }

    @Test
    @Issue(value="MULE-19744")
    public void constructConfigComponentType() {
        DefaultComponentAstBuilder config = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(CONSTRUCT_CONFIG, Collections.emptyMap()));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)config, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        MatcherAssert.assertThat((Object)config.getComponentType(), (Matcher)Is.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void listOfRoutes() {
        DefaultComponentAstBuilder router = (DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(LIST_OF_ROUTES_ID, Collections.emptyMap()));
        router.addChildComponent((BaseComponentAstBuilder)((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(ITEM_ROUTER, Collections.emptyMap()))));
        router.addChildComponent((BaseComponentAstBuilder)((DefaultComponentAstBuilder)Mockito.spy((Object)this.createModel(ITEM_ROUTER, Collections.emptyMap()))));
        ApplicationModelTypeUtils.resolveTypedComponentIdentifier((DefaultComponentAstBuilder)router, Optional.of(this.mockParentAstBuilder), (ExtensionModelHelper)this.extModelHelper);
        List<DefaultComponentAstBuilder> routes = router.childComponentsStream().collect(Collectors.toList());
        MatcherAssert.assertThat(routes, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
        routes.forEach(c -> {
            MatcherAssert.assertThat((Object)c.getModel(ParameterizedModel.class).isPresent(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)c.getModel(ParameterizedModel.class).isPresent(), (Matcher)Is.is((Object)true));
        });
    }

    private DefaultComponentAstBuilder buildOnce(DefaultComponentAstBuilder paramComponent) {
        AtomicReference paramComp = new AtomicReference();
        ((DefaultComponentAstBuilder)Mockito.doAnswer(inv -> paramComp.updateAndGet(alreadyBuilt -> {
            if (alreadyBuilt != null) {
                return alreadyBuilt;
            }
            try {
                return (ComponentAst)inv.callRealMethod();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        })).when((Object)paramComponent)).build();
        return paramComponent;
    }

    private DefaultComponentAstBuilder createModel(ComponentIdentifier identifier, Map<String, String> rawParams, List<DefaultComponentAstBuilder> children) {
        DefaultComponentAstBuilder component = this.createModel(identifier, rawParams);
        children.forEach(arg_0 -> ((DefaultComponentAstBuilder)component).addChildComponent(arg_0));
        return component;
    }

    private DefaultComponentAstBuilder createModel(ComponentIdentifier identifier, Map<String, String> rawParams, String body) {
        return (DefaultComponentAstBuilder)this.createModel(identifier, rawParams).withRawParameter("$%body%$", body);
    }

    private DefaultComponentAstBuilder createModel(ComponentIdentifier identifier, Map<String, String> rawParams) {
        ComponentAstBuilder builder = new DefaultComponentAstBuilder(new PropertiesResolver(), (ExtensionModelHelper)this.extModelHelper, Collections.emptyList(), 0, new ComponentLocationVisitor(), new ParameterModelUtils()).withIdentifier(identifier).withMetadata(DefaultComponentMetadataAst.builder().build());
        rawParams.forEach((arg_0, arg_1) -> ((ComponentAstBuilder)builder).withRawParameter(arg_0, arg_1));
        return (DefaultComponentAstBuilder)builder;
    }

    private Map<String, String> keyValueMap(String key, String value) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", key);
        hashMap.put("value", value);
        return hashMap;
    }

    public static class SimpleTextPojo {
        @Text
        @Parameter
        private String pojoTextParam;
    }

    public static class ComplexPojo {
        @Parameter
        private SimplePojo simple;
    }

    public static class ListPojo {
        @Parameter
        private List<SimplePojo> simples;
    }

    public static class ListTextPojo {
        @Parameter
        private List<SimpleTextPojo> simples;
    }

    public static class MapPojo {
        @Parameter
        private Map<String, SimplePojo> byKeySimples;
    }

    public static class MapString {
        @Parameter
        private Map<String, String> byKeyStrings;
    }

    @Extensible
    public static class SimpleExtensiblePojo {
        @Parameter
        private String pojoSimpleParam;
    }

    public static class SimplePojo {
        @Parameter
        private String pojoSimpleParam;
    }

    public class ParameterModelMatcher
    extends BaseMatcher<ParameterModel> {
        private final String paramName;

        public ParameterModelMatcher(String paramName) {
            this.paramName = Objects.requireNonNull(paramName);
        }

        public boolean matches(Object item) {
            if (item instanceof ParameterModel) {
                return this.paramName.equals(((ParameterModel)item).getName());
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.paramName);
        }
    }

    public class ParameterGroupValueModelMatcher
    extends BaseMatcher<ParameterGroupModel> {
        private final String paramGroupName;

        public ParameterGroupValueModelMatcher(String paramGroupName) {
            this.paramGroupName = Objects.requireNonNull(paramGroupName);
        }

        public boolean matches(Object item) {
            if (item instanceof ParameterGroupModel) {
                return this.paramGroupName.equals(((ParameterGroupModel)item).getName());
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.paramGroupName);
        }
    }

    public class ParameterRawValueModelMatcher
    extends BaseMatcher<ComponentParameterAst> {
        private final Matcher<?> rawParamValueMatcher;

        public ParameterRawValueModelMatcher(String rawParamValue) {
            this(Matchers.equalTo((Object)rawParamValue));
        }

        public ParameterRawValueModelMatcher(Matcher<?> rawParamValueMatcher) {
            this.rawParamValueMatcher = rawParamValueMatcher;
        }

        public boolean matches(Object item) {
            if (item instanceof ComponentParameterAst) {
                return this.rawParamValueMatcher.matches((Object)((ComponentParameterAst)item).getRawValue());
            }
            return false;
        }

        public void describeTo(Description description) {
            this.rawParamValueMatcher.describeTo(description);
        }
    }

    public class ParameterNestedValueModelMatcher
    extends BaseMatcher<ComponentParameterAst> {
        private final DefaultComponentAstBuilder nestedParamValue;

        public ParameterNestedValueModelMatcher(DefaultComponentAstBuilder nestedParamValue) {
            this.nestedParamValue = Objects.requireNonNull(nestedParamValue);
        }

        public boolean matches(Object item) {
            if (item instanceof ComponentParameterAst) {
                Object rightValue = ((ComponentParameterAst)item).getValue().getRight();
                return this.nestedParamValue.build().equals(rightValue);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.nestedParamValue.toString());
        }
    }

    public class ParameterNestedManyValueModelMatcher
    extends BaseMatcher<ComponentParameterAst> {
        private final List<DefaultComponentAstBuilder> nestedParamValue;

        public ParameterNestedManyValueModelMatcher(DefaultComponentAstBuilder ... nestedParamValue) {
            this.nestedParamValue = Arrays.asList(Objects.requireNonNull(nestedParamValue));
        }

        public boolean matches(Object item) {
            if (item instanceof ComponentParameterAst) {
                Object rightValue = ((ComponentParameterAst)item).getValue().getRight();
                return this.nestedParamValue.stream().map(DefaultComponentAstBuilder::build).collect(Collectors.toList()).equals(rightValue);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText(this.nestedParamValue.toString());
        }
    }

    public static class ConcreteComplexPojo
    extends AbstractPojo {
        @Parameter
        private SimplePojo simpleSubclass;
    }

    public static abstract class AbstractPojo {
        @Parameter
        private String pojoSuperclassParam;
    }
}

