/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.builder.ComponentMetadataAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultArtifactAstBuilder;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;

public class DefaultArtifactAstBuilderTestCase {
    public static final String NAME = "Name";
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private DefaultArtifactAstBuilder builder;
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private ArtifactAst artifactAst;
    @Mock
    private UnaryOperator<String> unaryOperator;
    @Mock
    private ExtensionModelHelper extensionModelHelper;
    @Mock
    private ComponentLocationVisitor componentLocationVisitor;
    @Mock
    private ParameterModelUtils parameterModelUtils;
    @Mock
    private ComponentAst component;
    @Mock
    private ErrorTypeRepository errorTypeRepo;
    @Mock
    private ImportedResource resource;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"mule");
        this.builder = new DefaultArtifactAstBuilder(NAME, ArtifactType.APPLICATION, (Set)ImmutableSet.of((Object)this.extensionModel), Optional.of(this.artifactAst), this.unaryOperator, this.extensionModelHelper, this.componentLocationVisitor, this.parameterModelUtils);
    }

    @Test
    public void buildWithNoSetup() {
        ArtifactAst result = this.builder.build();
        MatcherAssert.assertThat((Object)result.getArtifactName(), (Matcher)CoreMatchers.is((Object)NAME));
    }

    @Test
    public void addConstructedTopLevelComponent() {
        ArtifactAst result = this.builder.addTopLevelComponent(this.component).build();
        MatcherAssert.assertThat((Object)result.getArtifactName(), (Matcher)CoreMatchers.is((Object)NAME));
        MatcherAssert.assertThat((Object)result.topLevelComponents().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void withImportedResource() {
        ArtifactAst result = this.builder.withImportedResource(this.resource).build();
        MatcherAssert.assertThat((Object)result.getImportedResources().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)result.getImportedResources(), (Matcher)CoreMatchers.hasItem((Object)this.resource));
        ((ImportedResource)Mockito.verify((Object)this.resource)).updatePropertiesResolver((UnaryOperator)ArgumentMatchers.any());
    }

    @Test
    public void createMetadataBuilder() {
        ComponentMetadataAstBuilder result = this.builder.createMetadataBuilder();
        MatcherAssert.assertThat((Object)result.build(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

