/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;

@Feature(value="Mule Artifact AST")
@Story(value="AST traversal")
public class MuleAstUtilsComparationTestCase {
    private ComponentAst compA;
    private ComponentAst compB;
    private ComponentParameterAst paramA;
    private ComponentParameterAst paramB;

    @Before
    public void setUp() {
        this.paramA = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        this.paramB = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        this.compA = this.mockBaseComponentAst();
        this.compB = this.mockBaseComponentAst();
    }

    private ComponentAst mockBaseComponentAst() {
        ComponentAst comp = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)comp.getModel(ParameterizedModel.class)).thenReturn(Optional.of((ParameterizedModel)Mockito.mock(ParameterizedModel.class)));
        return comp;
    }

    @Test
    public void componentNonBehavior() {
        Mockito.when((Object)this.compA.getMetadata()).thenReturn((Object)((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)));
        Mockito.when((Object)this.compB.getMetadata()).thenReturn((Object)((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)));
        this.assertComponentsEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentIdentifier() {
        Mockito.when((Object)this.compA.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:OTHER_COMP"));
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentModel() {
        Mockito.when((Object)this.compA.getModel(Object.class)).thenReturn(Optional.of(Mockito.mock(ParameterizedModel.class)));
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentParamsSize() {
        Mockito.when((Object)this.compA.getParameters()).thenReturn(Collections.singleton(this.paramA));
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentParamsKeys() {
        ParameterModel paramModelA1 = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)paramModelA1.getName()).thenReturn((Object)"ParamA1");
        ParameterGroupModel paramGroupModelA = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupModelA.getName()).thenReturn((Object)"ParamGroupA");
        Mockito.when((Object)this.paramA.getGroupModel()).thenReturn((Object)paramGroupModelA);
        Mockito.when((Object)this.paramA.getModel()).thenReturn((Object)paramModelA1);
        ParameterModel paramModelB1 = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)paramModelB1.getName()).thenReturn((Object)"ParamB1");
        ParameterGroupModel paramGroupModelB = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupModelB.getName()).thenReturn((Object)"ParamGroupB");
        Mockito.when((Object)this.paramB.getGroupModel()).thenReturn((Object)paramGroupModelB);
        Mockito.when((Object)this.paramB.getModel()).thenReturn((Object)paramModelB1);
        Mockito.when((Object)this.compA.getParameters()).thenReturn(Collections.singleton(this.paramA));
        Mockito.when((Object)this.compB.getParameters()).thenReturn(Collections.singleton(this.paramB));
        Mockito.when((Object)this.compB.getParameter("ParamGroupA", "ParamA1")).thenReturn(null);
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentParamsValues() {
        ParameterModel paramModelA1 = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)paramModelA1.getName()).thenReturn((Object)"ParamA1");
        ParameterGroupModel paramGroupModelA = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)paramGroupModelA.getName()).thenReturn((Object)"ParamGroupA");
        Mockito.when((Object)this.paramA.getGroupModel()).thenReturn((Object)paramGroupModelA);
        Mockito.when((Object)this.paramA.getModel()).thenReturn((Object)paramModelA1);
        Mockito.when((Object)this.paramB.getGroupModel()).thenReturn((Object)paramGroupModelA);
        Mockito.when((Object)this.paramB.getModel()).thenReturn((Object)paramModelA1);
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.compA.getParameters()).thenReturn(Collections.singleton(this.paramA));
        Mockito.when((Object)this.compB.getParameters()).thenReturn(Collections.singleton(this.paramB));
        Mockito.when((Object)this.compB.getParameter("ParamGroupA", "ParamA1")).thenReturn((Object)this.paramB);
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentChildrenSize() {
        Mockito.when((Object)this.compA.directChildren()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.compB.directChildren()).thenReturn(Collections.singletonList((ComponentAst)Mockito.mock(ComponentAst.class)));
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void componentDifferentChildren() {
        ComponentAst compAChild = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst compBChild = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)compAChild.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)compBChild.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:OTHER_COMP"));
        Mockito.when((Object)this.compA.directChildren()).thenReturn(Collections.singletonList(compAChild));
        Mockito.when((Object)this.compB.directChildren()).thenReturn(Collections.singletonList(compBChild));
        this.assertComponentsNotEquals(this.compA, this.compB);
    }

    @Test
    public void paramNullValues() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn(null);
        Mockito.when((Object)this.paramB.getValue()).thenReturn(null);
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueNotPresent() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.empty());
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramNullToNotPresent() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn(null);
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.empty());
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramNullToExpression() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn(null);
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.left((Object)"#[payload]"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramNullToFixed() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn(null);
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)"value"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramNotPresentToExpression() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.left((Object)"#[payload]"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramNotPresentToFixed() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.empty());
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)"value"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramFixedToExpression() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.left((Object)"#[payload]"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)"value"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramSameExpressions() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.left((Object)"#[payload]"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.left((Object)"#[payload]"));
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramSameFixedValues() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)"value"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)"value"));
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramDifferentExpressions() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.left((Object)"#[payloadA]"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.left((Object)"#[payloadB]"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramDifferentFixedValues() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)"valueA"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)"valueB"));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramEqualComplexValues() {
        Mockito.when((Object)this.compA.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)this.compA));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)this.compB));
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramEqualListValue() {
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right(Collections.singletonList(this.compB)));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right(Collections.singletonList(this.compB)));
        this.assertParametersEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramDifferentComplexValues() {
        Mockito.when((Object)this.compA.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:OTHER_COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)this.compA));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)this.compB));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueSimpleToComplex() {
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)"valueA"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right((Object)this.compA));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueSimpleToList() {
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)"valueA"));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right(Collections.singletonList(this.compB)));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueComplexToList() {
        Mockito.when((Object)this.compA.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.compB.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right((Object)this.compA));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right(Collections.singletonList(this.compB)));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueListDifferentChildrenSize() {
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right(Collections.emptyList()));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right(Collections.singletonList((ComponentAst)Mockito.mock(ComponentAst.class))));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    @Test
    public void paramValueListDifferentChildren() {
        ComponentAst compAChild = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst compBChild = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)compAChild.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:COMP"));
        Mockito.when((Object)compBChild.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"MY:OTHER_COMP"));
        Mockito.when((Object)this.paramA.getValue()).thenReturn((Object)Either.right(Collections.singletonList(compAChild)));
        Mockito.when((Object)this.paramB.getValue()).thenReturn((Object)Either.right(Collections.singletonList(compBChild)));
        this.assertParametersNotEquals(this.paramA, this.paramB);
    }

    private void assertComponentsEquals(ComponentAst compA, ComponentAst compB) {
        MatcherAssert.assertThat((Object)MuleAstUtils.areComponentsEquals((ComponentAst)compA, (ComponentAst)compB), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)MuleAstUtils.areComponentsEquals((ComponentAst)compB, (ComponentAst)compA), (Matcher)Is.is((Object)true));
    }

    private void assertComponentsNotEquals(ComponentAst compA, ComponentAst compB) {
        MatcherAssert.assertThat((Object)MuleAstUtils.areComponentsEquals((ComponentAst)compA, (ComponentAst)compB), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)MuleAstUtils.areComponentsEquals((ComponentAst)compB, (ComponentAst)compA), (Matcher)Is.is((Object)false));
    }

    private void assertParametersEquals(ComponentParameterAst paramA, ComponentParameterAst paramB) {
        MatcherAssert.assertThat((Object)MuleAstUtils.areParametersEquals((ComponentParameterAst)paramA, (ComponentParameterAst)paramB), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)MuleAstUtils.areParametersEquals((ComponentParameterAst)paramB, (ComponentParameterAst)paramA), (Matcher)Is.is((Object)true));
    }

    private void assertParametersNotEquals(ComponentParameterAst paramA, ComponentParameterAst paramB) {
        MatcherAssert.assertThat((Object)MuleAstUtils.areParametersEquals((ComponentParameterAst)paramA, (ComponentParameterAst)paramB), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)MuleAstUtils.areParametersEquals((ComponentParameterAst)paramB, (ComponentParameterAst)paramA), (Matcher)Is.is((Object)false));
    }
}

