/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.error;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.ast.test.internal.error.TestErrorTypeRepositoryProvider;

@Feature(value="Mule Artifact AST")
@Story(value="Error types")
public class DefaultErrorTypeRepositoryTestCase {
    private final ErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
    private final ComponentIdentifier INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NS").name("NAME").build();
    private final ComponentIdentifier EXPOSED_ERROR = ComponentIdentifier.builder().namespace("NS2").name("OTHER_NAME").build();
    private final ComponentIdentifier OTHER_INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NS2").name("NAME").build();
    private TestErrorTypeRepositoryProvider errorTypeRepositoryProvider;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.errorTypeRepositoryProvider = new TestErrorTypeRepositoryProvider();
        this.errorTypeRepository.addErrorType(this.EXPOSED_ERROR, this.errorTypeRepositoryProvider.getAnyErrorType());
        this.errorTypeRepository.addInternalErrorType(this.INTERNAL_ERROR, this.errorTypeRepositoryProvider.getCriticalErrorType());
        this.errorTypeRepository.addInternalErrorType(this.OTHER_INTERNAL_ERROR, this.errorTypeRepositoryProvider.getCriticalErrorType());
    }

    @Test
    public void doesNotLookupUnavailableErrorType() {
        MatcherAssert.assertThat((Object)this.errorTypeRepositoryProvider.lookupErrorType(this.INTERNAL_ERROR).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getsUnavailableErrorTypes() {
        Optional myErrorType = this.errorTypeRepository.getErrorType(this.INTERNAL_ERROR);
        MatcherAssert.assertThat((Object)myErrorType.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorType)myErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"NAME"));
        MatcherAssert.assertThat((Object)((ErrorType)myErrorType.get()).getParentErrorType(), (Matcher)Matchers.is((Object)this.errorTypeRepositoryProvider.getCriticalErrorType()));
    }

    @Test
    public void doesNotAddInternalTypeAsRegularOne() {
        this.expectedException.expectMessage(Matchers.is((Object)"An error type with identifier 'NS:NAME' already exists"));
        this.errorTypeRepository.addErrorType(this.INTERNAL_ERROR, this.errorTypeRepositoryProvider.getAnyErrorType());
    }

    @Test
    public void returnsUnrepeatedExposedAndInternalNamespaces() {
        Collection errorNamespaces = this.errorTypeRepository.getErrorNamespaces();
        MatcherAssert.assertThat((Object)errorNamespaces, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)errorNamespaces, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"NS", "NS2"}));
    }

    @Test
    public void getErrorTypes() {
    }

    @Test
    public void getInternalErrorTypes() {
    }
}

