/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.stream;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;

@Feature(value="Mule Artifact AST")
@Story(value="AST traversal")
public class ComponentAstSpliteratorTestCase {
    @Test
    public void singleLevel() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        this.addChild(rootBuilder, "1");
        this.addChild(rootBuilder, "2");
        ComponentAst root = rootBuilder.build();
        MatcherAssert.assertThat(root.recursiveStream().map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "2"}));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.TOP_DOWN).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "2"}));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.BOTTOM_UP).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "root"}));
    }

    @Test
    public void twoLevels() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        ComponentAstBuilder child1Builder = this.addChild(rootBuilder, "1");
        this.addChild(child1Builder, "11");
        this.addChild(child1Builder, "12");
        ComponentAstBuilder child2Builder = this.addChild(rootBuilder, "2");
        this.addChild(child2Builder, "21");
        this.addChild(child2Builder, "22");
        ComponentAst root = rootBuilder.build();
        MatcherAssert.assertThat(root.recursiveStream().map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "11", "12", "2", "21", "22"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator().getExactSizeIfKnown(), (Matcher)Matchers.is((Object)7L));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.TOP_DOWN).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "11", "12", "2", "21", "22"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator(AstTraversalDirection.TOP_DOWN).getExactSizeIfKnown(), (Matcher)Matchers.is((Object)7L));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.BOTTOM_UP).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"11", "12", "1", "21", "22", "2", "root"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator(AstTraversalDirection.BOTTOM_UP).getExactSizeIfKnown(), (Matcher)Matchers.is((Object)7L));
    }

    @Test
    public void multipleLevels() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        ComponentAstBuilder child1Builder = this.addChild(rootBuilder, "1");
        this.addChild(child1Builder, "1_1");
        ComponentAstBuilder child12Builder = this.addChild(child1Builder, "1_2");
        this.addChild(child12Builder, "1_2_1");
        ComponentAstBuilder child122Builder = this.addChild(child12Builder, "1_2_2");
        this.addChild(child122Builder, "1_2_2_1");
        this.addChild(child122Builder, "1_2_2_2");
        this.addChild(child122Builder, "1_2_2_3");
        ComponentAstBuilder child2Builder = this.addChild(rootBuilder, "2");
        this.addChild(child2Builder, "2_1");
        this.addChild(rootBuilder, "3");
        ComponentAst root = rootBuilder.build();
        MatcherAssert.assertThat(root.recursiveStream().map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "1_1", "1_2", "1_2_1", "1_2_2", "1_2_2_1", "1_2_2_2", "1_2_2_3", "2", "2_1", "3"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator().getExactSizeIfKnown(), (Matcher)Matchers.is((Object)12L));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.TOP_DOWN).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"root", "1", "1_1", "1_2", "1_2_1", "1_2_2", "1_2_2_1", "1_2_2_2", "1_2_2_3", "2", "2_1", "3"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator(AstTraversalDirection.TOP_DOWN).getExactSizeIfKnown(), (Matcher)Matchers.is((Object)12L));
        MatcherAssert.assertThat(root.recursiveStream(AstTraversalDirection.BOTTOM_UP).map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1_1", "1_2_1", "1_2_2_1", "1_2_2_2", "1_2_2_3", "1_2_2", "1_2", "1", "2_1", "2", "3", "root"}));
        MatcherAssert.assertThat((Object)root.recursiveSpliterator(AstTraversalDirection.BOTTOM_UP).getExactSizeIfKnown(), (Matcher)Matchers.is((Object)12L));
    }

    @Test
    public void twoLevelsDirectOnly() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        ComponentAstBuilder child1Builder = this.addChild(rootBuilder, "1");
        this.addChild(child1Builder, "11");
        this.addChild(child1Builder, "12");
        ComponentAstBuilder child2Builder = this.addChild(rootBuilder, "2");
        this.addChild(child2Builder, "21");
        this.addChild(child2Builder, "22");
        ComponentAst root = rootBuilder.build();
        List visitedComponents = root.directChildrenStream().collect(Collectors.toList());
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(visitedComponents.stream().map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2"}));
    }

    @Test
    public void twoLevelsDirectOnly2() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        ComponentAstBuilder child1Builder = this.addChild(rootBuilder, "1");
        this.addChild(child1Builder, "11");
        ComponentAstBuilder child12Builder = this.addChild(child1Builder, "12");
        this.addChild(child12Builder, "121");
        ComponentAstBuilder child2Builder = this.addChild(rootBuilder, "2");
        this.addChild(child2Builder, "21");
        this.addChild(child2Builder, "22");
        ComponentAst root = rootBuilder.build();
        List visitedComponents = root.directChildrenStream().collect(Collectors.toList());
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(visitedComponents.stream().map(c -> c.getIdentifier().getName()).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"1", "2"}));
    }

    protected ComponentAstBuilder baseComponentBuilder(String name) {
        return new DefaultComponentAstBuilder(new PropertiesResolver(), (ExtensionModelHelper)new DefaultExtensionModelHelper(Collections.emptySet()), Collections.emptyList(), 0, new ComponentLocationVisitor(), new ParameterModelUtils()).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withIdentifier(ComponentIdentifier.builder().namespace("ns").name(name).build()).withMetadata(DefaultComponentMetadataAst.builder().build());
    }

    protected ComponentAstBuilder addChild(ComponentAstBuilder builder, String name) {
        return builder.addChildComponent().withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withIdentifier(ComponentIdentifier.builder().namespace("ns").name(name).build()).withMetadata(DefaultComponentMetadataAst.builder().build());
    }

    @Test
    public void fiveLevelsFiveChildrenEachDirectOnly() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        this.addLevel(rootBuilder, 1);
        ComponentAst root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        root.directChildrenStream().forEach(c -> visitedComponents.add(c));
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)5));
    }

    @Test
    public void fiveLevelsFiveChildrenEachParallel() {
        ComponentAstBuilder rootBuilder = this.baseComponentBuilder("root");
        this.addLevel(rootBuilder, 1);
        ComponentAst root = rootBuilder.build();
        ArrayList visitedComponents = new ArrayList();
        HashSet visitingThreads = new HashSet();
        ((Stream)root.recursiveStream().parallel()).forEach(c -> {
            visitedComponents.add(c);
            visitingThreads.add(Thread.currentThread());
        });
        MatcherAssert.assertThat(visitedComponents, (Matcher)Matchers.hasSize((int)3906));
    }

    protected void addLevel(ComponentAstBuilder rootBuilder, int level) {
        for (int i = 0; i < 5; ++i) {
            ComponentAstBuilder childBuilder = this.addChild(rootBuilder, "" + level + "." + i);
            if (level >= 5) continue;
            this.addLevel(childBuilder, level + 1);
        }
    }
}

