/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;

import java.util.Optional;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;


public class DefaultImportedResourceBuilderTestCase {

  @Rule
  public final MockitoRule mockitoRule = MockitoJUnit.rule();
  @Mock
  private ComponentMetadataAst metadata;
  private DefaultImportedResourceBuilder builder;

  @Before
  public void setUp() throws Exception {
    builder = new DefaultImportedResourceBuilder();
  }

  @Test(expected = NullPointerException.class)
  public void buildWithNoSetup() {
    builder.build();
  }

  @Test(expected = NullPointerException.class)
  public void buildWithOnlyLocation() {
    builder.withResourceLocation("foo").build();
  }

  @Test
  public void buildMinimalGood() {
    final ImportedResource result = builder.withMetadata(metadata).withResourceLocation("foo").build();
    assertThat(result.getMetadata(), is(metadata));
    assertThat(result.getRawResourceLocation(), is("foo"));
    assertThat(result.getRawResourceLocation(), is("foo"));
    assertThat(result.getResolutionFailure(), is(Optional.empty()));
  }

  @Test
  public void buildWithErrorGood() {
    final ImportedResource result =
        builder.withMetadata(metadata).withResourceLocation("foo").withResolutionFailure("Blarf").build();
    assertThat(result.getMetadata(), is(metadata));
    assertThat(result.getRawResourceLocation(), is("foo"));
    assertThat(result.getResolutionFailure(), is(Optional.of("Blarf")));
  }
}
