/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.api.annotation.NoImplement;
import org.mule.metadata.api.model.MetadataType;

/**
 * Adapter for using {@link MetadataType} instances consistently with other related but different models.
 *
 * @since 1.0
 */
@NoImplement
public interface MetadataTypeAdapter {

  /**
   * @return the adapted {@link MetadataType}.
   */
  MetadataType getType();

  /**
   * @param type the {@link MetadataType} to check
   * @return {@code true} if this adapter's wrapped type is the given {@code type}
   */
  boolean isWrapperFor(MetadataType type);

}
