/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.dsl;

import static java.lang.String.format;

/**
 * Mule DSL constants.
 *
 * This is an internal utils class (internal to the container, not the module), not to be considered part of the API. Backwards
 * compatibility not guaranteed.
 *
 * @since 1.3
 */
public interface DslConstants {

  /**
   * This is the namespace prefix for core elements in the configuration.
   */
  String CORE_PREFIX = "mule";

  /**
   * Format mask for the default location of a schema
   */
  String DEFAULT_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/%s";

  /**
   * Namespace for Mule core elements
   */
  String CORE_NAMESPACE = format(DEFAULT_NAMESPACE_URI_MASK, "core");

  /**
   * The prefix for components (operations, sources, etc) defined in the current application
   *
   * @since 1.5.0
   */
  String THIS_PREFIX = "this";

  /**
   * The namespace for components (operations, sources, etc) defined in the current application
   *
   * @since 1.5.0
   */
  String THIS_NAMESPACE = format(DEFAULT_NAMESPACE_URI_MASK, THIS_PREFIX);

  /**
   * This is the namespace prefix for EE elements in the configuration.
   */
  String EE_PREFIX = "ee";

  /**
   * The name of the 'name' attribute of a DSL element
   */
  String NAME_ATTRIBUTE_NAME = "name";

  /**
   * The name of the 'config' attribute of an executable element in the DSL
   */
  String CONFIG_ATTRIBUTE_NAME = "config-ref";

  /**
   * The name of the 'key' element of a Map DSL entry
   */
  String KEY_ATTRIBUTE_NAME = "key";

  /**
   * The name of the 'value' element of a Map DSL entry
   */
  String VALUE_ATTRIBUTE_NAME = "value";

  /**
   * The prefix name of the {@code tls:context} infrastructure parameter
   */
  String TLS_PREFIX = "tls";

  /**
   * The identifier name of the {@code errorMapping} infrastructure parameter
   */
  String ERROR_MAPPING_ELEMENT_IDENTIFIER = "error-mapping";
}
