/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api;

import org.mule.api.annotation.NoImplement;

import java.util.Map;

/**
 * Represents the namespace definition of an {@link ArtifactAst}
 *
 * @since 1.0
 */
@NoImplement
public interface NamespaceDefinition {

  /**
   * @return a {@link Map} with the unresolved namespaces with its' schema locations
   */
  Map<String, String> getUnresovedNamespaces();

  /**
   * @return a {@link Map} with the namespaces' schema locations.
   */
  Map<String, String> getSchemaLocations();

  /**
   * @return this namespace's prefix
   */
  String getPrefix();

  /**
   * @return this namespace's name (definition)
   */
  String getNamespace();
}
