/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.builder;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

import java.util.List;

/**
 * Provides a way of creating {@link ComponentParameterAst} instances.
 *
 * @see {@link ComponentAstBuilder#withParameter(ParameterModel, ParameterGroupModel, java.util.function.Consumer)}
 *
 * @since 1.6
 */
@NoImplement
public interface ComponentParameterAstBuilder {

  /**
   * Calls {@link #withComponentGenerationInformation(ComponentGenerationInformation)} with a new
   * {@link ComponentGenerationInformation} created with the given {@code syntax}.
   *
   * @param syntax the syntax representation of the parameter element.
   * @return this builder
   */
  ComponentParameterAstBuilder withSyntax(DslElementSyntax syntax);

  /**
   *
   * @param metadata the parser metadata for the target component parameter.
   * @return this builder
   */
  ComponentParameterAstBuilder withMetadata(ComponentMetadataAst metadata);

  /**
   * Sets a value for the target component parameter.
   *
   * @param rawValue
   * @return this builder
   */
  ComponentParameterAstBuilder withValue(String rawValue);

  /**
   * Sets a value for the target component parameter.
   *
   * @param rawValue
   * @return this builder
   */
  ComponentParameterAstBuilder withValue(ComponentAstBuilder complexValue);

  /**
   * Sets a value for the target component parameter.
   *
   * @param rawValue
   * @return this builder
   */
  ComponentParameterAstBuilder withValue(List<ComponentAstBuilder> complexValue);

  /**
   * Builds the target component parameter.
   *
   * @return the target component parameter
   */
  ComponentParameterAst build();

}
