/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationVisitorTestCase {
    private static final ComponentIdentifier COMPONENT_IDENTIFIER = ComponentIdentifier.builder().name("fuzzbutt").namespace("xmlns:fuzzy").namespaceUri("http://fuzzbutt.com").build();
    private static final Optional<String> COMPONENT_ID = Optional.of("componentId");
    private static final Optional<String> PARENT_COMPONENT_ID = Optional.of("parentId");
    public static final String CHILD_COMPONENT_INDEX = "-1";
    private static ComponentLocationVisitor visitor;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private DefaultComponentAstBuilder componentModel;
    @Mock
    private ComponentMetadataAst componentMetadata;
    @Mock
    private DefaultComponentAstBuilder parent;
    @Mock
    private DefaultComponentLocation parentLocation;
    @Mock(extraInterfaces={ConstructModel.class, SourceModel.class, ConnectionProviderModel.class, EnrichableModel.class})
    private ConfigurationModel parentConfigurationModel;
    @Captor
    private ArgumentCaptor<ComponentLocation> locationCaptor;
    @Captor
    private ArgumentCaptor<Optional<TypedComponentIdentifier>> componentIdentifierCaptor;

    @Before
    public void setup() {
        Mockito.when((Object)this.componentModel.getMetadata()).thenReturn((Object)this.componentMetadata);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)COMPONENT_IDENTIFIER);
        visitor = new ComponentLocationVisitor();
    }

    @Test
    public void resolveLocationWithNoHierarchy() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.componentModel.getComponentId()).thenReturn(COMPONENT_ID);
        visitor.resolveLocation(this.componentModel, Arrays.asList(new DefaultComponentAstBuilder[0]));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)this.componentModel)).withLocation((ComponentLocation)this.locationCaptor.capture());
        MatcherAssert.assertThat((Object)((ComponentLocation)this.locationCaptor.getValue()).getLocation(), (Matcher)CoreMatchers.is((Object)"componentId"));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Chain() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CHAIN);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)this.componentModel)).withLocation((ComponentLocation)this.locationCaptor.capture());
        MatcherAssert.assertThat((Object)((ComponentLocation)this.locationCaptor.getValue()).getLocation(), (Matcher)CoreMatchers.is((Object)"parentId"));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_RootParent() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpTopLevelParent();
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentAstBuilder)Mockito.verify((Object)this.componentModel)).withLocation((ComponentLocation)ArgumentMatchers.any());
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_customModel() throws InvocationTargetException, IllegalAccessException {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.componentModel.getModel(EnrichableModel.class)).thenReturn(Optional.of(this.parentConfigurationModel));
        ModelProperty modelProperty = (ModelProperty)Mockito.mock(ModelProperty.class);
        Mockito.when((Object)this.parentConfigurationModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(modelProperty));
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        ComponentLocationVisitor visitorSpy = (ComponentLocationVisitor)Mockito.spy((Object)visitor);
        ((ComponentLocationVisitor)Mockito.doReturn(ModelPropertyHarness.class).when((Object)visitorSpy)).getModelPropertyClass();
        ((ComponentLocationVisitor)Mockito.doReturn((Object)true).when((Object)visitorSpy)).isModelIndexed((ModelProperty)ArgumentMatchers.any());
        ((ComponentLocationVisitor)Mockito.doReturn((Object)"CustomModelPath").when((Object)visitorSpy)).getCustomModelLocationPath((ModelProperty)ArgumentMatchers.any());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)newProcessor);
        DefaultComponentLocation innerLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)newProcessor.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)innerLocation);
        visitorSpy.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)newProcessor)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_customModel_badConfig() throws InvocationTargetException, IllegalAccessException {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.componentModel.getModel(EnrichableModel.class)).thenReturn(Optional.of(this.parentConfigurationModel));
        ModelProperty modelProperty = (ModelProperty)Mockito.mock(ModelProperty.class);
        Mockito.when((Object)this.parentConfigurationModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(modelProperty));
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        ComponentLocationVisitor visitorSpy = (ComponentLocationVisitor)Mockito.spy((Object)visitor);
        ((ComponentLocationVisitor)Mockito.doReturn(ModelPropertyHarness.class).when((Object)visitorSpy)).getModelPropertyClass();
        ((ComponentLocationVisitor)Mockito.doReturn((Object)true).when((Object)visitorSpy)).isModelIndexed((ModelProperty)ArgumentMatchers.any());
        ((ComponentLocationVisitor)Mockito.doThrow((Throwable[])new Throwable[]{new ComponentLocationVisitor.BadCustomModelPropertyConfigException((Exception)new NullPointerException("Test"))}).when((Object)visitorSpy)).getCustomModelLocationPath((ModelProperty)ArgumentMatchers.any());
        visitorSpy.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_customModel_notIndexed() throws InvocationTargetException, IllegalAccessException {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.componentModel.getModel(EnrichableModel.class)).thenReturn(Optional.of(this.parentConfigurationModel));
        ModelProperty modelProperty = (ModelProperty)Mockito.mock(ModelProperty.class);
        Mockito.when((Object)this.parentConfigurationModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(modelProperty));
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        ComponentLocationVisitor visitorSpy = (ComponentLocationVisitor)Mockito.spy((Object)visitor);
        ((ComponentLocationVisitor)Mockito.doReturn(ModelPropertyHarness.class).when((Object)visitorSpy)).getModelPropertyClass();
        ((ComponentLocationVisitor)Mockito.doReturn((Object)false).when((Object)visitorSpy)).isModelIndexed((ModelProperty)ArgumentMatchers.any());
        ((ComponentLocationVisitor)Mockito.doReturn((Object)"CustomModelPath").when((Object)visitorSpy)).getCustomModelLocationPath((ModelProperty)ArgumentMatchers.any());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)newProcessor);
        visitorSpy.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"CustomModelPath"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_deprecatedCustomModel() throws InvocationTargetException, IllegalAccessException {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.componentModel.getModel(EnrichableModel.class)).thenReturn(Optional.of(this.parentConfigurationModel));
        ModelProperty modelProperty = (ModelProperty)Mockito.mock(ModelProperty.class);
        Mockito.when((Object)this.parentConfigurationModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.of(modelProperty));
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        ComponentLocationVisitor visitorSpy = (ComponentLocationVisitor)Mockito.spy((Object)visitor);
        ((ComponentLocationVisitor)Mockito.doReturn(ModelPropertyHarness.class).when((Object)visitorSpy)).getDeprecatedModelPropertyClass();
        ((ComponentLocationVisitor)Mockito.doReturn((Object)true).when((Object)visitorSpy)).isDeprecatedModelIndexed((ModelProperty)ArgumentMatchers.any());
        ((ComponentLocationVisitor)Mockito.doReturn((Object)"CustomModelPath").when((Object)visitorSpy)).getDeprecatedLocationPath((ModelProperty)ArgumentMatchers.any());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)newProcessor);
        DefaultComponentLocation innerLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)newProcessor.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)innerLocation);
        visitorSpy.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)newProcessor)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_ErrorHandler() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"errorHandler"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_ErrorTemplate() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.ON_ERROR);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.childComponentsStream()).thenReturn(Stream.of(this.componentModel));
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.ON_ERROR));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Processor() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.OPERATION);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.getModel(SourceModel.class)).thenReturn(Optional.empty());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendProcessorsPart()).thenReturn((Object)newProcessor);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)newProcessor)).appendLocationPart((String)ArgumentMatchers.eq((Object)CHILD_COMPONENT_INDEX), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Connection() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.getModel(SourceModel.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModel(ConnectionProviderModel.class)).thenReturn(Optional.of((ConnectionProviderModel)this.parentConfigurationModel));
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendConnectionPart((Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Flow_Processor() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.OPERATION);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.getModel(SourceModel.class)).thenReturn(Optional.empty());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)newProcessor);
        this.setUpTopLevelParent();
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)newProcessor)).appendLocationPart((String)ArgumentMatchers.eq((Object)CHILD_COMPONENT_INDEX), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_MessageSource() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.SOURCE);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.getModel(SourceModel.class)).thenReturn(Optional.empty());
        DefaultComponentLocation newProcessor = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendProcessorsPart()).thenReturn((Object)newProcessor);
        this.setUpTopLevelParent();
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"source"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.SOURCE));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Root_ErrorHandler() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)this.parent.getModel(SourceModel.class)).thenReturn(Optional.empty());
        this.setUpTopLevelParent();
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"errorHandler"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_ParentRouter() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.ROUTER);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_ParentAndChildRouter() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.ROUTE);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.ROUTER);
        DefaultComponentLocation newLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendRoutePart()).thenReturn((Object)newLocation);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendRoutePart();
        ((DefaultComponentLocation)Mockito.verify((Object)newLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)CHILD_COMPONENT_INDEX), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.ROUTE));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneThatHasAConfigurationModel_Config_ParentRouter_ChildProcessor() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.OPERATION);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.ROUTER);
        DefaultComponentLocation newLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)this.parentLocation.appendRoutePart()).thenReturn((Object)newLocation);
        DefaultComponentLocation routeLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)newLocation.appendLocationPart((String)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any())).thenReturn((Object)routeLocation);
        DefaultComponentLocation newProcessorLocation = (DefaultComponentLocation)Mockito.mock(DefaultComponentLocation.class);
        Mockito.when((Object)routeLocation.appendProcessorsPart()).thenReturn((Object)newProcessorLocation);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendRoutePart();
        ((DefaultComponentLocation)Mockito.verify((Object)newLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)CHILD_COMPONENT_INDEX), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.eq((Object)OptionalInt.empty()), (OptionalInt)ArgumentMatchers.eq((Object)OptionalInt.empty()));
        ((DefaultComponentLocation)Mockito.verify((Object)routeLocation)).appendProcessorsPart();
        ((DefaultComponentLocation)Mockito.verify((Object)newProcessorLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.OPERATION));
    }

    @Test
    public void resolveLocationWithHierarchyOfOneNotRoot() {
        Mockito.when((Object)this.componentModel.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        this.setUpParent(this.parent, TypedComponentIdentifier.ComponentType.CONFIG);
        visitor.resolveLocation(this.componentModel, Arrays.asList(this.parent));
        ((DefaultComponentLocation)Mockito.verify((Object)this.parentLocation)).appendLocationPart((String)ArgumentMatchers.eq((Object)"0"), (Optional)this.componentIdentifierCaptor.capture(), (Optional)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any(), (OptionalInt)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((Optional)this.componentIdentifierCaptor.getValue()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((TypedComponentIdentifier)((Optional)this.componentIdentifierCaptor.getValue()).get()).getType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.CONFIG));
    }

    @Test
    public void checkThatGetBooleanBehavesProperly() throws NoSuchMethodException {
        Method m = ModelPropertyHarness.class.getDeclaredMethod("isPublic", new Class[0]);
        ModelPropertyHarness model = new ModelPropertyHarness();
        MatcherAssert.assertThat((Object)ComponentLocationVisitor.getBoolean((Method)m, (ModelProperty)model), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ComponentLocationVisitor.getBoolean(null, (ModelProperty)model), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void checkThatGetStringBehavesProperly() throws NoSuchMethodException {
        Method m = ModelPropertyHarness.class.getDeclaredMethod("getName", new Class[0]);
        ModelPropertyHarness model = new ModelPropertyHarness();
        MatcherAssert.assertThat((Object)ComponentLocationVisitor.getString((Method)m, (ModelProperty)model), (Matcher)CoreMatchers.is((Object)"TestPropertyModel"));
        MatcherAssert.assertThat((Object)ComponentLocationVisitor.getString(null, (ModelProperty)model), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void setUpParent(DefaultComponentAstBuilder parent, TypedComponentIdentifier.ComponentType config) {
        Mockito.when((Object)parent.getComponentType()).thenReturn((Object)config);
        Mockito.when((Object)parent.getComponentId()).thenReturn(PARENT_COMPONENT_ID);
        Mockito.when((Object)parent.getModel(ConfigurationModel.class)).thenReturn(Optional.of(this.parentConfigurationModel));
        Mockito.when((Object)parent.getLocation()).thenReturn((Object)this.parentLocation);
    }

    private void setUpTopLevelParent() {
        Mockito.when((Object)this.parent.getModel(ConstructModel.class)).thenReturn(Optional.of((ConstructModel)this.parentConfigurationModel));
        Mockito.when((Object)((ConstructModel)this.parentConfigurationModel).allowsTopLevelDeclaration()).thenReturn((Object)true);
    }

    static class ModelPropertyHarness
    implements ModelProperty {
        ModelPropertyHarness() {
        }

        public String getName() {
            return "TestPropertyModel";
        }

        public boolean isPublic() {
            return true;
        }
    }
}

