/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Mule implementation of its Abstract Syntax Tree
 *
 * @moduleGraph
 * @since 1.2
 */

import org.mule.api.annotation.jpms.PrivilegedApi;

@PrivilegedApi(
    privilegedPackages = {"org.mule.runtime.ast.privileged.error"},
    privilegedArtifactIds = {}
)
module org.mule.runtime.artifact.ast {

  requires java.transaction.xa;

  requires org.mule.runtime.api.annotations;
  requires transitive org.mule.runtime.api;
  requires org.mule.runtime.extensions.api;
  requires transitive org.mule.runtime.metadata.model.api;
  requires org.mule.runtime.metadata.model.java;
  requires org.mule.runtime.dsl.api;
  requires org.mule.sdk.api;

  requires com.github.benmanes.caffeine;
  requires org.apache.commons.lang3;

  exports org.mule.runtime.ast.api;
  exports org.mule.runtime.ast.api.builder;
  exports org.mule.runtime.ast.api.error;
  exports org.mule.runtime.ast.api.exception;
  exports org.mule.runtime.ast.api.model;
  exports org.mule.runtime.ast.api.util;
  exports org.mule.runtime.ast.api.validation;

  exports org.mule.runtime.ast.privileged.error;

  exports org.mule.runtime.ast.internal.builder to
      org.mule.runtime.artifact.ast.xmlParser,
      org.mule.runtime.artifact.ast.serialization;
  exports org.mule.runtime.ast.internal.builder.adapter to
      org.mule.runtime.artifact.ast.serialization,
      com.mulesoft.mule.runtime.ee.extension.model;
  exports org.mule.runtime.ast.internal.dsl to
      org.mule.runtime.artifact.ast.xmlParser,
      org.mule.runtime.artifact.ast.serialization;
  exports org.mule.runtime.ast.internal.error to
      org.mule.runtime.artifact.ast.xmlParser,
      org.mule.runtime.artifact.ast.serialization,
      org.mule.runtime.artifact.cfg;
  exports org.mule.runtime.ast.internal.model to
      org.mule.runtime.artifact.ast.xmlParser,
      org.mule.runtime.artifact.ast.serialization,
      org.mule.runtime.artifact.cfg;
  exports org.mule.runtime.ast.internal.param to
      org.mule.runtime.artifact.ast.serialization;

  opens org.mule.runtime.ast.privileged.error;

  uses org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
  uses org.mule.runtime.ast.api.validation.ValidationsProvider;

}
