/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.validation;

import static java.lang.String.format;
import static java.util.regex.Pattern.compile;

import java.util.regex.Pattern;

/**
 * Declare constants that can be used by implementation validations.
 *
 * @since 1.4
 */
public interface ImportValidationConstants {

  String IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_TEMPLATE = "Imported resource '%s' declares a '%s', not a '%s'";
  Pattern IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_PATTERN = compile(format(IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_TEMPLATE,
                                                                        "[^']+", "[^']+", "[^']+"));

}
