/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.error;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.ast.internal.error.ErrorTypeRepositoryBuildingUtils;
import org.mule.runtime.ast.test.internal.error.TestErrorTypeRepositoryProvider;

@Feature(value="Mule Artifact AST")
@Story(value="Error types")
public class ErrorTypeRepositoryBuildingUtilsTestCase {
    public static final String CONNECTIVITY_ERROR_IDENTIFIER = "CONNECTIVITY";
    public static final String SOURCE_RESPONSE_GENERATE_ERROR_IDENTIFIER = "SOURCE_RESPONSE_GENERATE";
    public static final ComponentIdentifier SOURCE_RESPONSE_GENERATE = ComponentIdentifier.builder().namespace("mule".toUpperCase()).name("SOURCE_RESPONSE_GENERATE").build();
    private static final String TEST_EXTENSION_NAME = "Test Extension";
    private static final String EXTENSION_PREFIX = "test-namespace";
    private static final String ERROR_PREFIX = "test-namespace".toUpperCase();
    private static final String OPERATION_NAME = "operationName";
    private static final String TEST_CONNECTIVITY_ERROR_TYPE = "TEST_CONNECTIVITY";
    private static final String OAUTH_TEST_CONNECTIVITY_ERROR_TYPE = "OAUTH_CONNECTIVITY";
    private static final ErrorModel MULE_CONNECTIVITY_ERROR = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)"mule".toUpperCase()).build();
    private static final ErrorModel extensionConnectivityError = ErrorModelBuilder.newError((String)"TEST_CONNECTIVITY", (String)ERROR_PREFIX).withParent(MULE_CONNECTIVITY_ERROR).build();
    private static final ErrorModel oauthExtensionConnectivityError = ErrorModelBuilder.newError((String)"OAUTH_CONNECTIVITY", (String)ERROR_PREFIX).withParent(extensionConnectivityError).build();
    private static final TestErrorTypeRepositoryProvider errorTypeRepositoryProvider = new TestErrorTypeRepositoryProvider();
    private static final ErrorModel customErrorModel = ErrorModelBuilder.newError((String)"CUSTOM", (String)"mule".toUpperCase()).withParent(ErrorModelBuilder.newError((String)errorTypeRepositoryProvider.getAnyErrorType().getIdentifier(), (String)errorTypeRepositoryProvider.getAnyErrorType().getNamespace()).build()).build();
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().silent();
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationWithError;
    @Mock(lenient=true)
    private OperationModel operationWithoutErrors;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ErrorTypeRepository typeRepository;
    private MockedStatic<ErrorTypeRepositoryProvider> mockStaticErrorTypeRepositoryProvider;

    @Before
    public void setUp() {
        XmlDslModel.XmlDslModelBuilder builder = XmlDslModel.builder();
        builder.setPrefix(EXTENSION_PREFIX);
        XmlDslModel xmlDslModel = builder.build();
        this.typeRepository = new DefaultErrorTypeRepository();
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationWithError, this.operationWithoutErrors));
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)TEST_EXTENSION_NAME);
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        Mockito.when((Object)this.operationWithError.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationWithError.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationWithoutErrors.getName()).thenReturn((Object)"operationWithoutError");
        Mockito.when((Object)this.operationWithoutErrors.getErrorModels()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.operationWithoutErrors.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        ErrorTypeRepositoryBuildingUtilsTestCase.visitableMock(new ComponentModel[]{this.operationWithError, this.operationWithoutErrors});
        this.mockStaticErrorTypeRepositoryProvider = Mockito.mockStatic(ErrorTypeRepositoryProvider.class);
        this.mockStaticErrorTypeRepositoryProvider.when(ErrorTypeRepositoryProvider::getCoreErrorTypeRepo).thenReturn((Object)errorTypeRepositoryProvider);
    }

    @After
    public void tearDown() {
        this.mockStaticErrorTypeRepositoryProvider.close();
    }

    @Test
    public void lookupErrorsForOperation() {
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(Collections.singleton(this.extensionModel), (ErrorTypeRepository)this.typeRepository);
        ErrorType errorType = (ErrorType)this.typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(EXTENSION_PREFIX.toUpperCase()).name(CONNECTIVITY_ERROR_IDENTIFIER).build()).get();
        ErrorType muleConnectivityError = errorType.getParentErrorType();
        MatcherAssert.assertThat((Object)muleConnectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getNamespace()));
        MatcherAssert.assertThat((Object)muleConnectivityError.getIdentifier(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getType()));
        MatcherAssert.assertThat((Object)muleConnectivityError.getParentErrorType(), (Matcher)CoreMatchers.is((Object)ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType()));
    }

    @Test
    public void registerErrorTypes() {
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(oauthExtensionConnectivityError));
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(Collections.singleton(this.extensionModel), (ErrorTypeRepository)this.typeRepository);
        Optional optionalOAuthType = this.typeRepository.lookupErrorType(ComponentIdentifier.builder().name(OAUTH_TEST_CONNECTIVITY_ERROR_TYPE).namespace(EXTENSION_PREFIX).build());
        Optional optionalConnectivityType = this.typeRepository.lookupErrorType(ComponentIdentifier.builder().name(TEST_CONNECTIVITY_ERROR_TYPE).namespace(EXTENSION_PREFIX).build());
        MatcherAssert.assertThat((Object)optionalOAuthType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)optionalConnectivityType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorType parentErrorType = ((ErrorType)optionalOAuthType.get()).getParentErrorType();
        MatcherAssert.assertThat((Object)parentErrorType, (Matcher)CoreMatchers.is((Object)((ErrorType)optionalConnectivityType.get())));
    }

    @Test
    public void operationWithoutErrorsDoesntGenerateComponentMapper() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationWithoutErrors));
        this.typeRepository = (ErrorTypeRepository)Mockito.spy((Object)this.typeRepository);
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(Collections.singleton(this.extensionModel), (ErrorTypeRepository)this.typeRepository);
        ((ErrorTypeRepository)Mockito.verify((Object)this.typeRepository, (VerificationMode)Mockito.never())).addErrorType((ComponentIdentifier)ArgumentMatchers.any(), (ErrorType)ArgumentMatchers.any());
        ((ErrorTypeRepository)Mockito.verify((Object)this.typeRepository, (VerificationMode)Mockito.never())).addInternalErrorType((ComponentIdentifier)ArgumentMatchers.any(), (ErrorType)ArgumentMatchers.any());
    }

    @Test
    public void operationTriesToAddInternalErrorType() {
        ErrorModel internalRepeatedError = ErrorModelBuilder.newError((ComponentIdentifier)SOURCE_RESPONSE_GENERATE).build();
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(internalRepeatedError));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationWithError));
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(internalRepeatedError));
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(Collections.singleton(this.extensionModel), (ErrorTypeRepository)this.typeRepository);
        MatcherAssert.assertThat((Object)this.typeRepository.lookupErrorType(SOURCE_RESPONSE_GENERATE), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void extensionCantRegisterAMuleErrorType() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("The extension [Test Extension] tried to register the [MULE:CUSTOM] error with [MULE] namespace, which is not allowed");
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(customErrorModel));
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(customErrorModel));
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(Collections.singleton(this.extensionModel), (ErrorTypeRepository)this.typeRepository);
    }

    private static void visitableMock(ComponentModel ... components) {
        for (ComponentModel component : components) {
            ((ComponentModel)Mockito.lenient().doAnswer(invocation -> {
                ComponentModelVisitor visitor = (ComponentModelVisitor)invocation.getArguments()[0];
                if (component instanceof ConstructModel) {
                    visitor.visit((ConstructModel)component);
                } else if (component instanceof OperationModel) {
                    visitor.visit((OperationModel)component);
                } else if (component instanceof SourceModel) {
                    visitor.visit((SourceModel)component);
                } else if (component instanceof NestedComponentModel) {
                    visitor.visit((NestedComponentModel)component);
                } else if (component instanceof NestedChainModel) {
                    visitor.visit((NestedChainModel)component);
                } else if (component instanceof NestedRouteModel) {
                    visitor.visit((NestedRouteModel)component);
                } else {
                    throw new IllegalArgumentException("Unsupported visitable mock of class " + component.getClass().getName());
                }
                return null;
            }).when((Object)component)).accept((ComponentModelVisitor)Mockito.any(ComponentModelVisitor.class));
        }
    }
}

