/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.error.ErrorTypeRepositoryBuildingUtils;
import org.mule.runtime.extension.api.error.ErrorMapping;

@Feature(value="Mule Artifact AST")
@Story(value="Error types")
public class ErrorTypeRepositoryBuildingUtilsTestCase {
    private ComponentMetadataAst metadata;
    private OperationModel someOperationModel;
    private ArtifactAst artifactAst;
    private ComponentAst chain;
    private ErrorTypeRepository errorTypeRepository;

    @Before
    public void setUp() {
        this.metadata = DefaultComponentMetadataAst.builder().setFileName("mule-app.xml").build();
        this.someOperationModel = (OperationModel)Mockito.mock(OperationModel.class);
        this.chain = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.chain.getMetadata()).thenReturn((Object)this.metadata);
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)this.artifactAst.topLevelComponentsStream()).thenReturn(Stream.of(this.chain));
        this.errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
    }

    private void withMockCoreErrorTypeRepository(Runnable test) {
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            ServiceLoader fromRuntimeLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
            Mockito.when(fromRuntimeLoader.iterator()).thenAnswer(inv -> Collections.singletonList(() -> this.errorTypeRepository).iterator());
            loaderClass.when(() -> ServiceLoader.load((Class)ArgumentMatchers.eq(ErrorTypeRepositoryProvider.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class))).thenReturn((Object)fromRuntimeLoader);
            test.run();
        }
    }

    @Test
    public void errorTypesFromRaiseError() {
        ComponentParameterAst errorTypeParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)errorTypeParam.getValue()).thenReturn((Object)Either.right((Object)"TEST:RAISED_ERROR"));
        ComponentAst raiseError = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)raiseError.getIdentifier()).thenReturn((Object)ErrorTypeRepositoryBuildingUtils.RAISE_ERROR_IDENTIFIER);
        Mockito.when((Object)raiseError.getParameter("General", "type")).thenReturn((Object)errorTypeParam);
        Mockito.when((Object)raiseError.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)raiseError.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)this.chain.directChildrenStream()).thenReturn(Stream.of(raiseError));
        this.withMockCoreErrorTypeRepository(() -> {
            ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact((ArtifactAst)this.artifactAst, (ErrorTypeRepository)this.errorTypeRepository);
            ((ErrorTypeRepository)Mockito.verify((Object)this.errorTypeRepository)).addErrorType(ComponentIdentifier.builder().namespace("TEST").name("RAISED_ERROR").build(), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        });
    }

    @Test
    public void errorTypesFromErrorMappings() {
        ComponentParameterAst errorMappingsParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)errorMappingsParam.getValue()).thenReturn((Object)Either.right(Collections.singletonList(new ErrorMapping("TEST-EXT:OP_ERROR", "TEST:MAPPED_ERROR"))));
        ComponentAst someOperation = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)someOperation.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace("test-ext").name("operation").build());
        Mockito.when((Object)someOperation.getParameter("Error Mappings", "errorMappings")).thenReturn((Object)errorMappingsParam);
        Mockito.when((Object)someOperation.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)someOperation.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)someOperation.getModel(OperationModel.class)).thenReturn(Optional.of(this.someOperationModel));
        Mockito.when((Object)this.chain.directChildrenStream()).thenReturn(Stream.of(someOperation));
        this.withMockCoreErrorTypeRepository(() -> {
            ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact((ArtifactAst)this.artifactAst, (ErrorTypeRepository)this.errorTypeRepository);
            ((ErrorTypeRepository)Mockito.verify((Object)this.errorTypeRepository)).addErrorType(ComponentIdentifier.builder().namespace("TEST").name("MAPPED_ERROR").build(), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        });
    }

    @Test
    public void coreErrorTypesFromRaiseError() {
        ComponentParameterAst errorTypeParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)errorTypeParam.getValue()).thenReturn((Object)Either.right((Object)"RAISED_ERROR"));
        ComponentAst raiseError = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)raiseError.getIdentifier()).thenReturn((Object)ErrorTypeRepositoryBuildingUtils.RAISE_ERROR_IDENTIFIER);
        Mockito.when((Object)raiseError.getParameter("General", "type")).thenReturn((Object)errorTypeParam);
        Mockito.when((Object)raiseError.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)raiseError.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)this.chain.directChildrenStream()).thenReturn(Stream.of(raiseError));
        this.withMockCoreErrorTypeRepository(() -> {
            ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact((ArtifactAst)this.artifactAst, (ErrorTypeRepository)this.errorTypeRepository);
            ((ErrorTypeRepository)Mockito.verify((Object)this.errorTypeRepository, (VerificationMode)Mockito.never())).addErrorType((ComponentIdentifier)ArgumentMatchers.any(), (ErrorType)ArgumentMatchers.any());
        });
    }

    @Test
    public void coreErrorTypesFromErrorMappings() {
        ComponentParameterAst errorMappingsParam = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)errorMappingsParam.getValue()).thenReturn((Object)Either.right(Collections.singletonList(new ErrorMapping("TEST-EXT:OP_ERROR", "MAPPED_ERROR"))));
        ComponentAst someOperation = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)someOperation.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace("test-ext").name("operation").build());
        Mockito.when((Object)someOperation.getParameter("Error Mappings", "errorMappings")).thenReturn((Object)errorMappingsParam);
        Mockito.when((Object)someOperation.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)someOperation.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)someOperation.getModel(OperationModel.class)).thenReturn(Optional.of(this.someOperationModel));
        Mockito.when((Object)this.chain.directChildrenStream()).thenReturn(Stream.of(someOperation));
        this.withMockCoreErrorTypeRepository(() -> {
            ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact((ArtifactAst)this.artifactAst, (ErrorTypeRepository)this.errorTypeRepository);
            ((ErrorTypeRepository)Mockito.verify((Object)this.errorTypeRepository, (VerificationMode)Mockito.never())).addErrorType((ComponentIdentifier)ArgumentMatchers.any(), (ErrorType)ArgumentMatchers.any());
        });
    }
}

