/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

@Feature(value="Mule Artifact AST")
@Story(value="AST traversal")
public class ArtifactAstTestCase {
    private static final String HTTP = "http";
    private static final String LISTENER = "listener";
    private static final String EE = "ee";
    private static final String TRANSFORM = "transform";
    private static final String MULE = "mule";
    private static final String FLOW = "flow";
    private static final String CHILD_1_LOCATION = "child-1-location";
    private static final String CHILD_2_LOCATION = "child-2-location";
    private static final String CHILD_2_1_LOCATION = "child-2.1-location";
    private static final String CHILD_2_2_LOCATION = "child-2.2-location";

    @Test
    public void filterComponentsByeEqualsIdentifierPredicate() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        List components = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)this.createFlowComponentIdentifier())).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)IsCollectionWithSize.hasSize((int)2));
        components = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)this.createComponentIdentifier(HTTP, LISTENER))).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void filterComponentsByNonExistingIdentifier() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        List components = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)this.createComponentIdentifier("NS", "NAME"))).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void filterComponentsByEqualsLocationPredicate() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        Optional componentAst = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsLocation((ComponentLocation)DefaultComponentLocation.from((String)CHILD_1_LOCATION))).findFirst();
        MatcherAssert.assertThat(componentAst, (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
        componentAst = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsLocation((ComponentLocation)DefaultComponentLocation.from((String)CHILD_2_2_LOCATION))).findFirst();
        MatcherAssert.assertThat(componentAst, (Matcher)Is.is((Matcher)IsNot.not(Optional.empty())));
    }

    @Test
    public void filterComponentsByNonExistingLocation() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        Optional componentAst = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsLocation((ComponentLocation)DefaultComponentLocation.from((String)"unknown"))).findFirst();
        MatcherAssert.assertThat(componentAst, (Matcher)Is.is(Optional.empty()));
    }

    @Test
    public void filterComponentsByNamespacePredicate() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        List components = artifactAst.filteredComponents(ComponentAstPredicatesFactory.equalsNamespace((String)EE)).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void getDirectChildrenByName() {
        ArtifactAst artifactAst = this.createArtifactAstWithTwoLevels();
        ComponentAst child2 = artifactAst.recursiveStream().filter(c -> c.getLocation().equals(DefaultComponentLocation.from((String)CHILD_2_LOCATION))).findFirst().get();
        List listeners = child2.directChildrenStreamByIdentifier(HTTP, LISTENER).collect(Collectors.toList());
        MatcherAssert.assertThat(listeners, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAst listener = (ComponentAst)listeners.get(0);
        MatcherAssert.assertThat((Object)listener.getIdentifier().getNamespace(), (Matcher)CoreMatchers.equalTo((Object)HTTP));
        MatcherAssert.assertThat((Object)listener.getIdentifier().getName(), (Matcher)CoreMatchers.equalTo((Object)LISTENER));
    }

    private ComponentIdentifier createFlowComponentIdentifier() {
        return ComponentIdentifier.builder().namespace(MULE).name(FLOW).build();
    }

    private ComponentIdentifier createComponentIdentifier(String namespace, String name) {
        return ComponentIdentifier.builder().namespace(namespace).name(name).build();
    }

    private ArtifactAst createArtifactAstWithTwoLevels() {
        ComponentAst child1 = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)child1.getIdentifier()).thenReturn((Object)this.createFlowComponentIdentifier());
        Mockito.when((Object)child1.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)CHILD_1_LOCATION));
        Mockito.when((Object)child1.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)child1.recursiveStream()).thenAnswer(inv -> Stream.of(child1));
        ComponentAst child21 = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)child21.getIdentifier()).thenReturn((Object)this.createComponentIdentifier(HTTP, LISTENER));
        Mockito.when((Object)child21.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)CHILD_2_1_LOCATION));
        Mockito.when((Object)child21.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)child21.recursiveStream()).thenAnswer(inv -> Stream.of(child21));
        ComponentAst child22 = (ComponentAst)Mockito.mock(BaseComponentAst.class);
        Mockito.when((Object)child22.getIdentifier()).thenReturn((Object)this.createComponentIdentifier(EE, TRANSFORM));
        Mockito.when((Object)child22.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)CHILD_2_2_LOCATION));
        Mockito.when((Object)child22.directChildrenStream()).thenAnswer(inv -> Stream.empty());
        Mockito.when((Object)child22.recursiveStream()).thenAnswer(inv -> Stream.of(child22));
        ComponentAst child2 = (ComponentAst)Mockito.mock(BaseComponentAst.class, (Answer)Answers.CALLS_REAL_METHODS);
        Mockito.when((Object)child2.getIdentifier()).thenReturn((Object)this.createFlowComponentIdentifier());
        Mockito.when((Object)child2.getLocation()).thenReturn((Object)DefaultComponentLocation.from((String)CHILD_2_LOCATION));
        Mockito.when((Object)child2.directChildrenStream()).thenAnswer(inv -> Stream.of(child21, child22));
        Mockito.when((Object)child2.recursiveStream()).thenAnswer(inv -> Stream.of(child2, child21, child22));
        ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(BaseArtifactAst.class);
        Mockito.when((Object)artifactAst.recursiveStream()).thenAnswer(inv -> Stream.concat(child1.recursiveStream(), child2.recursiveStream()));
        Mockito.when((Object)artifactAst.filteredComponents((Predicate)ArgumentMatchers.any())).thenCallRealMethod();
        return artifactAst;
    }
}

