/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.validation;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.internal.validation.DefaultValidationResult;

@Feature(value="Mule Artifact AST")
@Story(value="Validations")
public class DefaultValidationResultTestCase {
    @Test
    public void duplicateComponentFilter() {
        DefaultValidationResult result = new DefaultValidationResult();
        ComponentAst componentA = (ComponentAst)Mockito.mock(ComponentAst.class);
        Validation validationA = (Validation)Mockito.mock(Validation.class);
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (Validation)validationA, (String)"failed :("));
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (Validation)validationA, (String)"failed :("));
        MatcherAssert.assertThat((Object)result.getItems(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    @Issue(value="MULE-19963")
    public void notDuplicateComponentFilter() {
        DefaultValidationResult result = new DefaultValidationResult();
        ComponentAst componentA = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst componentB = (ComponentAst)Mockito.mock(ComponentAst.class);
        Validation validationA = (Validation)Mockito.mock(Validation.class);
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (Validation)validationA, (String)"failed :("));
        result.addItem(ValidationResultItem.create((ComponentAst)componentB, (Validation)validationA, (String)"failed :("));
        MatcherAssert.assertThat((Object)result.getItems(), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void duplicateParameterFilter() {
        DefaultValidationResult result = new DefaultValidationResult();
        ComponentAst componentA = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst paramA = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Validation validationA = (Validation)Mockito.mock(Validation.class);
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (ComponentParameterAst)paramA, (Validation)validationA, (String)"failed :("));
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (ComponentParameterAst)paramA, (Validation)validationA, (String)"failed :("));
        MatcherAssert.assertThat((Object)result.getItems(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    @Issue(value="MULE-19963")
    public void notDuplicateParameterFilter() {
        DefaultValidationResult result = new DefaultValidationResult();
        ComponentAst componentA = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst paramA = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        ComponentParameterAst paramB = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Validation validationA = (Validation)Mockito.mock(Validation.class);
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (ComponentParameterAst)paramA, (Validation)validationA, (String)"failed :("));
        result.addItem(ValidationResultItem.create((ComponentAst)componentA, (ComponentParameterAst)paramB, (Validation)validationA, (String)"failed :("));
        MatcherAssert.assertThat((Object)result.getItems(), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }
}

