/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class AllExecutionPathsVisitor
implements ChainExecutionPathTreeVisitor {
    private final Deque<List<List<ComponentAst>>> executions = new ArrayDeque<List<List<ComponentAst>>>();
    private final Deque<Integer> errorHandling = new ArrayDeque<Integer>();
    private final Deque<Boolean> firstNestedErrorHandler = new ArrayDeque<Boolean>();

    public AllExecutionPathsVisitor() {
        this.addEmptyExecution();
    }

    private void add(ComponentAst ast) {
        for (List<ComponentAst> possibleExecutions : this.executions.peek()) {
            if (!this.shouldMerge(possibleExecutions, ast)) continue;
            possibleExecutions.add(ast);
        }
    }

    public List<List<ComponentAst>> getAllPossibleExecutions() {
        if (this.executions.size() != 1) {
            throw new IllegalStateException("Executions should have finished with just one flattened list with all the possibilities");
        }
        return this.executions.peek();
    }

    public void visitSource(ChainExecutionPathTree source) {
        this.add(source.getComponentAst());
    }

    public void visitSimpleOperation(ChainExecutionPathTree operation) {
        this.add(operation.getComponentAst());
    }

    public boolean visitScope(ChainExecutionPathTree scope) {
        this.add(scope.getComponentAst());
        this.addEmptyExecution();
        return true;
    }

    public boolean visitRouter(ChainExecutionPathTree router) {
        this.add(router.getComponentAst());
        return true;
    }

    public void innerRouteStarted(ChainExecutionPathTree innerChain) {
        this.addEmptyExecution();
    }

    public void innerRouteFinished(ChainExecutionPathTree innerChain) {
    }

    public void scopeFinished(ChainExecutionPathTree scope) {
        this.finishedContainer(1);
    }

    public void routerFinished(ChainExecutionPathTree router) {
        this.finishedContainer(router.getComponentAst().directChildren().size());
    }

    private boolean shouldMerge(List<ComponentAst> previous, ComponentAst nextFirst) {
        if (previous.isEmpty()) {
            return true;
        }
        ComponentAst previousLast = previous.get(previous.size() - 1);
        if (previousLast.getComponentType() != TypedComponentIdentifier.ComponentType.ON_ERROR) {
            return true;
        }
        if (!previousLast.getLocation().getRootContainerName().equals(nextFirst.getLocation().getRootContainerName())) {
            return true;
        }
        return !nextFirst.getLocation().getLocation().contains(previousLast.getLocation().getLocation().split("errorHandler")[0]);
    }

    private boolean shouldMerge(List<ComponentAst> previous, List<ComponentAst> next) {
        if (previous.isEmpty() || next.isEmpty()) {
            return true;
        }
        return this.shouldMerge(previous, next.get(0));
    }

    private void finishedContainer(int branches) {
        ArrayList<List<List<ComponentAst>>> branchedExecutions = new ArrayList<List<List<ComponentAst>>>();
        for (int i = 0; i < branches; ++i) {
            branchedExecutions.add(this.executions.pop());
        }
        HashSet<Integer> addedIndexesAlone = new HashSet<Integer>();
        ArrayList mergedPeek = new ArrayList();
        List<List<ComponentAst>> possibleExecutions = this.executions.pop();
        for (int i = 0; i < possibleExecutions.size(); ++i) {
            for (List list : branchedExecutions) {
                for (List newPossible : list) {
                    ArrayList newRoute = new ArrayList();
                    newRoute.addAll(possibleExecutions.get(i));
                    if (this.shouldMerge(possibleExecutions.get(i), newPossible)) {
                        newRoute.addAll(newPossible);
                        mergedPeek.add(newRoute);
                        continue;
                    }
                    if (addedIndexesAlone.contains(i)) continue;
                    addedIndexesAlone.add(i);
                    mergedPeek.add(newRoute);
                }
            }
        }
        this.executions.push(mergedPeek);
    }

    void addEmptyExecution() {
        ArrayList init = new ArrayList();
        init.add(new ArrayList());
        this.executions.push(init);
    }

    public boolean errorHandlingStartsFor(ChainExecutionPathTree component) {
        this.addEmptyExecution();
        this.errorHandling.push(1);
        this.firstNestedErrorHandler.push(true);
        return true;
    }

    public boolean errorHandlerStarted(ErrorType errorType, ChainExecutionPathTree handler) {
        this.addEmptyExecution();
        this.add(handler.getComponentAst());
        return true;
    }

    public void errorHandlerPropagationComplete(ErrorType errorType, ChainExecutionPathTree handler) {
        this.errorHandling.push(this.errorHandling.pop() + 1);
        this.add(handler.getComponentAst());
        this.firstNestedErrorHandler.pop();
        this.firstNestedErrorHandler.push(true);
    }

    public void errorHandlerFinished(ChainExecutionPathTree handler) {
        if (this.firstNestedErrorHandler.peek().booleanValue()) {
            this.firstNestedErrorHandler.pop();
            this.firstNestedErrorHandler.push(false);
        } else {
            this.finishedContainer(1);
        }
    }

    public void errorHandlingFinishedFor(ChainExecutionPathTree component) {
        this.finishedContainer(this.errorHandling.pop());
        this.firstNestedErrorHandler.pop();
    }

    public void chainFinishedSuccess() {
    }

    public void chainFinishedSuccessWithResponse(ChainExecutionPathTree source) {
    }

    public void chainFinishedError() {
    }

    public void chainFinishedErrorWithResponse(ChainExecutionPathTree source) {
    }
}

