/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.NullNode;

public class ChainedExecutionPathNodeBuilder {
    private final ComponentAst chainAst;
    private ChainNode first;
    private ChainNode last;
    private boolean continueAdding = true;

    public ChainedExecutionPathNodeBuilder(ComponentAst chainAst) {
        this.chainAst = chainAst;
    }

    public ChainedExecutionPathNodeBuilder addChild(ChainExecutionPathTree child) {
        if (!this.continueAdding) {
            return this;
        }
        ChainNode newNode = new ChainNode(child);
        if (this.first == null) {
            this.first = newNode;
        } else {
            this.last.next = Optional.of(newNode);
        }
        this.last = newNode;
        this.continueAdding = !child.allExecutionPathsContain(ast -> ast.getComponentAst().getIdentifier().getName().equals("raise-error"));
        return this;
    }

    public ChainExecutionPathTree build() {
        return new HeadNode(this.chainAst, this.first != null ? this.first : new ChainNode(new NullNode()));
    }

    private static class ChainNode
    implements ChainExecutionPathTree {
        private final ChainExecutionPathTree delegate;
        public Optional<ChainNode> next = Optional.empty();

        private ChainNode(ChainExecutionPathTree delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor) {
            this.delegate.accept(visitor);
            this.next.ifPresent(node -> node.accept(visitor));
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.delegate.getComponentAst();
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return this.delegate.anyExecutionPathContains(predicate) || this.next.map(node -> node.anyExecutionPathContains(predicate)).orElse(false) != false;
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return this.delegate.allExecutionPathsContain(predicate) || this.next.map(node -> node.allExecutionPathsContain(predicate)).orElse(false) != false;
        }
    }

    public static class HeadNode
    implements ChainExecutionPathTree {
        private final ComponentAst chainAst;
        private final ChainNode firstNode;

        public HeadNode(ComponentAst chainAst, ChainNode firstNode) {
            this.chainAst = chainAst;
            this.firstNode = firstNode;
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor) {
            this.firstNode.accept(visitor);
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.chainAst;
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return this.firstNode.anyExecutionPathContains(predicate);
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return this.firstNode.allExecutionPathsContain(predicate);
        }
    }
}

