/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.utils.CfgTestUtils;
import org.mule.runtime.cfg.visitors.CountingVisitor;

@Feature(value="Control Flow Graph")
@Story(value="Traversal of CFG Tree using visitor")
public class SimpleVisitingTestCase {
    @Test
    public void countOnSimpleApplication() {
        ChainExecutionPathTree tree = CfgTestUtils.testTree();
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countOnApplicationWithErrorHandling() {
        ChainExecutionPathTree tree = CfgTestUtils.testTreeWithErrorHandling();
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)3));
    }
}

