/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.api;

import org.mule.runtime.api.message.ErrorType;

/**
 * Base implementation of {@link ChainExecutionPathTreeVisitor} with default methods implementation.
 * 
 * @since 1.1.
 */
public class BaseChainExecutionPathTreeVisitor implements ChainExecutionPathTreeVisitor {

  @Override
  public void visitSource(ChainExecutionPathTree source) {

  }

  @Override
  public void visitSimpleOperation(ChainExecutionPathTree operation) {

  }

  @Override
  public boolean visitScope(ChainExecutionPathTree scope) {
    return true;
  }

  @Override
  public void scopeFinished(ChainExecutionPathTree scope) {

  }

  @Override
  public boolean visitRouter(ChainExecutionPathTree router) {
    return true;
  }

  @Override
  public void innerRouteStarted(ChainExecutionPathTree innerChain) {

  }

  @Override
  public void innerRouteFinished(ChainExecutionPathTree innerChain) {

  }

  @Override
  public void routerFinished(ChainExecutionPathTree router) {

  }

  @Override
  public boolean errorHandlingStartsFor(ChainExecutionPathTree component) {
    return true;
  }

  @Override
  public boolean errorHandlerStarted(ErrorType errorType, ChainExecutionPathTree handler) {
    return true;
  }

  @Override
  public void errorHandlerFinished(ChainExecutionPathTree handler) {

  }

  @Override
  public void errorHandlerPropagationComplete(ErrorType errorType, ChainExecutionPathTree handler) {

  }

  @Override
  public void errorHandlingFinishedFor(ChainExecutionPathTree component) {

  }

  @Override
  public void chainFinishedSuccess() {

  }

  @Override
  public void chainFinishedSuccessWithResponse(ChainExecutionPathTree source) {

  }

  @Override
  public void chainFinishedError() {

  }

  @Override
  public void chainFinishedErrorWithResponse(ChainExecutionPathTree source) {

  }
}
