/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node;

import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

import java.util.Optional;
import java.util.function.Predicate;

import static java.util.Optional.empty;

public abstract class AbstractWithErrorsNode implements ChainExecutionPathTree {

  protected final Optional<ChainExecutionPathTree> errorHandlers;

  public AbstractWithErrorsNode(Optional<ChainExecutionPathTree> errorHandlers) {
    this.errorHandlers = errorHandlers;
  }

  protected abstract void doAccept(ChainExecutionPathTreeVisitor visitor);

  @Override
  public void accept(ChainExecutionPathTreeVisitor visitor) {
    doAccept(visitor);
    errorHandlers.ifPresent(handlers -> {
      if (visitor.errorHandlingStartsFor(this)) {
        handlers.accept(visitor);
      }
      visitor.errorHandlingFinishedFor(this);
    });
  }

  protected boolean anyErrorHandlerExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
    return errorHandlers.map(handlers -> handlers.anyExecutionPathContains(predicate)).orElse(false);
  }
}
