/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ThrowsErrors;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

import java.util.Optional;

import static java.util.stream.Collectors.toList;

/**
 * Utils to be used by different implementations of {@link ChainExecutionPathTree} when needed.
 */
class NodeUtils {

  private NodeUtils() {

  }

  private static ErrorType toErrorType(ErrorModel errorModel) {
    ErrorTypeBuilder builder = ErrorTypeBuilder.builder().identifier(errorModel.getType()).namespace(errorModel.getNamespace());
    errorModel.getParent().ifPresent(p -> builder.parentErrorType(toErrorType(p)));
    return builder.build();
  }

  public static Optional<ChainExecutionPathTree> getErrorHandlers(ComponentAst componentAst, ErrorHandlingContext errorHandlers) {
    return componentAst.getModel(ThrowsErrors.class).flatMap(throwsError -> errorHandlers
        .getMatchingErrorHandlerFor(throwsError.getErrorModels().stream().map(NodeUtils::toErrorType).collect(toList())));
  }
}
