/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node;

import static org.mule.runtime.cfg.internal.node.NodeUtils.getErrorHandlers;

import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

import java.util.Optional;
import java.util.function.Predicate;

public class SimpleOperationNode extends AbstractWithErrorsNode {

  private final ComponentAst componentAst;

  public SimpleOperationNode(ComponentAst componentAst, ErrorHandlingContext errorHandlers) {
    super(getErrorHandlers(componentAst, errorHandlers));
    this.componentAst = componentAst;
  }

  @Override
  protected void doAccept(ChainExecutionPathTreeVisitor visitor) {
    visitor.visitSimpleOperation(this);
  }

  @Override
  public ComponentAst getComponentAst() {
    return componentAst;
  }

  @Override
  public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
    return predicate.test(this) || anyErrorHandlerExecutionPathContains(predicate);
  }

  @Override
  public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
    // we could consider the error handler when this is a raise-error (TODO W-12390971)
    return predicate.test(this);
  }

}
