/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import static java.util.Optional.empty;
import static java.util.Optional.of;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ErrorHandlingContext {

  private final LinkedList<ErrorHandlerNode> context = new LinkedList<>();

  public ErrorHandlingContext(boolean addNullEH) {
    if (addNullEH) {
      context.addFirst(new ErrorHandlingExecutionPathNodeBuilder(null).build());
    }
  }

  public ErrorHandlingContext() {
    this(false);
  }

  public Optional<ChainExecutionPathTree> getMatchingErrorHandlerFor(List<ErrorType> errorTypes) {
    Map<ErrorType, ErrorHandlerNode> handlers = new HashMap<>();
    errorTypes.forEach(err -> context.stream().filter(handler -> handler.appliesTo(err)).findFirst()
        .ifPresent(handler -> handlers.put(err, handler)));
    return handlers.isEmpty() ? empty() : of(new ErrorHandlerWrapper(handlers));
  }

  public void addPropagateHandler(ErrorHandlerNode errorHandlingNode) {
    errorHandlingNode.setOuters(new LinkedList<>(context));
    context.addFirst(errorHandlingNode);
  }

  public void addContinueHandler(ErrorHandlerNode errorHandlingNode) {
    context.addFirst(errorHandlingNode);
  }

  public void removeLastHandlers(int count) {
    for (int i = 0; i < count; i++) {
      context.removeFirst();
    }
  }

}
