/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.queries;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.utils.CfgTestUtils;

@Feature(value="Control Flow Graph")
@Story(value="Query process to the CFG Tree")
public class SimpleTreeQueriesTestCase {
    private ChainExecutionPathTree tree;

    @Before
    public void setup() {
        this.tree = CfgTestUtils.testTree();
    }

    @Test
    public void elementNotPresent() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void elementIsInOneRoute() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void elementIsInAllRoutes() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SCATTER_GATHER)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SCATTER_GATHER)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SCATTER_GATHER)), (Matcher)CoreMatchers.is((Object)false));
    }
}

