/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.AbstractWithErrorsNode;
import org.mule.runtime.cfg.internal.node.NodeUtils;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

public class RouterExecutionPathNodeBuilder {
    private ComponentAst routerAst;
    private List<ChainExecutionPathTree> children = new ArrayList<ChainExecutionPathTree>();
    private Optional<ChainExecutionPathTree> errorHandlers = Optional.empty();

    public RouterExecutionPathNodeBuilder(ComponentAst ast) {
        this.routerAst = ast;
    }

    public RouterExecutionPathNodeBuilder withRoute(ChainExecutionPathTree child) {
        this.children.add(child);
        return this;
    }

    public RouterExecutionPathNodeBuilder withErrorHandlerContext(ErrorHandlingContext context) {
        this.errorHandlers = NodeUtils.getErrorHandlers(this.routerAst, context);
        return this;
    }

    public ChainExecutionPathTree build() {
        return new RouterNode(this.routerAst, this.children, this.errorHandlers);
    }

    private static class RouterNode
    extends AbstractWithErrorsNode {
        private final ComponentAst routerAst;
        private final List<ChainExecutionPathTree> children;

        private RouterNode(ComponentAst componentAst, List<ChainExecutionPathTree> children, Optional<ChainExecutionPathTree> errorHandlers) {
            super(errorHandlers);
            this.routerAst = componentAst;
            this.children = children;
        }

        @Override
        protected void doAccept(ChainExecutionPathTreeVisitor visitor) {
            if (!visitor.visitRouter(this)) {
                return;
            }
            this.children.forEach(child -> {
                visitor.innerRouteStarted((ChainExecutionPathTree)child);
                child.accept(visitor);
                visitor.innerRouteFinished((ChainExecutionPathTree)child);
            });
            visitor.routerFinished(this);
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.routerAst;
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            if (predicate.test(this)) {
                return true;
            }
            for (ChainExecutionPathTree child : this.children) {
                if (!child.anyExecutionPathContains(predicate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            if (predicate.test(this)) {
                return true;
            }
            for (ChainExecutionPathTree child : this.children) {
                if (!NodeUtils.isChainAlwaysExecuted(child.getComponentAst()) || !child.allExecutionPathsContain(predicate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<ChainExecutionPathTree> children() {
            return Collections.unmodifiableList(this.children);
        }
    }
}

