/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.AbstractWithErrorsNode;
import org.mule.runtime.cfg.internal.node.NodeUtils;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

public class ScopeExecutionPathNodeBuilder {
    private ComponentAst scopeAst;
    private ChainExecutionPathTree child;
    private Optional<ChainExecutionPathTree> errorHandlers = Optional.empty();

    public ScopeExecutionPathNodeBuilder(ComponentAst ast) {
        this.scopeAst = ast;
    }

    public ScopeExecutionPathNodeBuilder withErrorHandlerContext(ErrorHandlingContext context) {
        this.errorHandlers = NodeUtils.getErrorHandlers(this.scopeAst, context);
        return this;
    }

    public ScopeExecutionPathNodeBuilder withChild(ChainExecutionPathTree child) {
        this.child = child;
        return this;
    }

    public ChainExecutionPathTree build() {
        return new ScopeNode(this.scopeAst, this.child, this.errorHandlers);
    }

    private static class ScopeNode
    extends AbstractWithErrorsNode {
        private final ComponentAst scopeAst;
        private final ChainExecutionPathTree child;

        private ScopeNode(ComponentAst componentAst, ChainExecutionPathTree child, Optional<ChainExecutionPathTree> errorHandlers) {
            super(errorHandlers);
            this.scopeAst = componentAst;
            this.child = child;
        }

        @Override
        protected void doAccept(ChainExecutionPathTreeVisitor visitor) {
            if (!visitor.visitScope(this)) {
                return;
            }
            this.child.accept(visitor);
            visitor.scopeFinished(this);
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.scopeAst;
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return predicate.test(this) || this.child.anyExecutionPathContains(predicate);
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return predicate.test(this) || NodeUtils.isChainAlwaysExecuted(this.child.getComponentAst()) && this.child.allExecutionPathsContain(predicate);
        }

        @Override
        public List<ChainExecutionPathTree> children() {
            return Collections.singletonList(this.child);
        }
    }
}

