/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcherUtils;
import org.mule.runtime.api.meta.model.error.ThrowsErrors;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.internal.node.ChainedExecutionPathNodeBuilder;
import org.mule.runtime.cfg.internal.node.NullNode;
import org.mule.runtime.cfg.internal.node.ReferencedChainNode;
import org.mule.runtime.cfg.internal.node.RouterExecutionPathNodeBuilder;
import org.mule.runtime.cfg.internal.node.ScopeExecutionPathNodeBuilder;
import org.mule.runtime.cfg.internal.node.SimpleOperationNode;
import org.mule.runtime.cfg.internal.node.SourceNode;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerNode;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingExecutionPathNodeBuilder;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class ChainExecutionPathTreeFactory {
    private static final String FLOW_REF = "flow-ref";
    private static final String RAISE_ERROR = "raise-error";
    private static final String BATCH_NAMESPACE = "batch";
    private static final ComponentIdentifier BATCH_ON_COMPLETE = ComponentIdentifier.builder().namespace("batch").name("on-complete").build();
    private static final String ANY_POSSIBLE_ERROR = "MULE:ANY";
    private final ArtifactAst application;
    private final Map<String, ChainExecutionPathTree> cachedTrees = new HashMap<String, ChainExecutionPathTree>();

    public ChainExecutionPathTreeFactory(ArtifactAst application) {
        this.application = application;
    }

    public ChainExecutionPathTree generateFor(ComponentAst chainComponentAst) {
        return this.cachedTrees.computeIfAbsent(chainComponentAst.getLocation().getLocation(), location -> this.recursiveGenerateFor(chainComponentAst, new ErrorHandlingContext()));
    }

    private ChainExecutionPathTree generateForWithoutFlows(ComponentAst chainComponentAst) {
        return this.cachedTrees.computeIfAbsent(chainComponentAst.getLocation().getLocation(), location -> this.recursiveGenerateFor(chainComponentAst, new ErrorHandlingContext(), false));
    }

    private ChainExecutionPathTree recursiveGenerateFor(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers) {
        return this.recursiveGenerateFor(chainComponentAst, errorHandlers, true);
    }

    private ChainExecutionPathTree recursiveGenerateFor(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers, boolean includeSources) {
        switch (chainComponentAst.getComponentType()) {
            case OPERATION: {
                return this.getOperationNode(chainComponentAst, errorHandlers);
            }
            case SOURCE: {
                return includeSources ? new SourceNode(chainComponentAst) : NullNode.getInstance();
            }
            case FLOW: 
            case SUB_FLOW: 
            case CHAIN: 
            case ROUTE: {
                return this.getNestedChainFrom(chainComponentAst, errorHandlers, includeSources);
            }
            case ROUTER: {
                return this.createRouter(chainComponentAst, errorHandlers);
            }
            case SCOPE: {
                return this.createScope(chainComponentAst, errorHandlers);
            }
            case ERROR_HANDLER: {
                chainComponentAst.directChildren().stream().collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                    Collections.reverse(l);
                    return l;
                })).forEach(child -> this.recursiveGenerateFor((ComponentAst)child, errorHandlers));
                return null;
            }
            case ON_ERROR: {
                this.processErrorHandler(chainComponentAst, errorHandlers);
                return null;
            }
            case UNKNOWN: {
                if (chainComponentAst.getIdentifier().equals(BATCH_ON_COMPLETE)) {
                    return this.createScope(chainComponentAst, errorHandlers);
                }
                if (!chainComponentAst.getIdentifier().getNamespace().equals(BATCH_NAMESPACE)) break;
                return this.getNestedChainFrom(chainComponentAst, errorHandlers, includeSources);
            }
        }
        throw new IllegalStateException(String.format("ComponentType of ComponentAST is not currently handled by the factory. Component: %s. Location: %s", chainComponentAst.getIdentifier().getName(), chainComponentAst.getLocation().getLocation()));
    }

    private void processErrorHandler(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers) {
        String errorExpression = chainComponentAst.getParameter("General", "type").getRawValue();
        if (errorExpression == null) {
            errorExpression = ANY_POSSIBLE_ERROR;
        }
        ErrorHandlerNode errHandler = new ErrorHandlingExecutionPathNodeBuilder(chainComponentAst).setChild(this.getNestedChainFrom(chainComponentAst, errorHandlers, false)).setErrorMatcher(ErrorTypeMatcherUtils.createErrorTypeMatcher((ErrorTypeRepository)this.application.getErrorTypeRepository(), (String)errorExpression)).build();
        if (chainComponentAst.getIdentifier().getName().equals("on-error-propagate")) {
            errorHandlers.addPropagateHandler(errHandler);
        } else if (chainComponentAst.getIdentifier().getName().equals("on-error-continue")) {
            errorHandlers.addContinueHandler(errHandler);
        } else {
            throw new IllegalStateException("Identifier type not supported: " + chainComponentAst.getIdentifier().getName());
        }
    }

    private ChainExecutionPathTree getNestedChainFrom(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers, boolean includeSources) {
        ArrayList<ComponentAst> children = new ArrayList<ComponentAst>(chainComponentAst.directChildren());
        Optional<ComponentAst> hasEH = this.getErrorHandler(children);
        hasEH.ifPresent(err -> this.recursiveGenerateFor((ComponentAst)err, errorHandlers));
        ChainedExecutionPathNodeBuilder builder = new ChainedExecutionPathNodeBuilder(chainComponentAst);
        children.forEach(child -> builder.addChild(this.recursiveGenerateFor((ComponentAst)child, errorHandlers, includeSources)));
        hasEH.ifPresent(err -> errorHandlers.removeLastHandlers(err.directChildren().size()));
        ChainExecutionPathTree node = builder.build();
        if (node == null) {
            throw new RuntimeException("empty route/scope/flow");
        }
        return node;
    }

    private Optional<ComponentAst> getErrorHandler(List<ComponentAst> children) {
        if (children.size() == 0) {
            return Optional.empty();
        }
        return children.get(children.size() - 1).getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER) ? Optional.of(children.remove(children.size() - 1)) : Optional.empty();
    }

    private Optional<ComponentAst> getTopLevelElementWithName(String name) {
        return this.application.topLevelComponentsStream().filter(ast -> ast.getComponentId().map(id -> id.equals(name)).orElse(false)).findFirst();
    }

    private boolean propagatesErrorHandlingContext(ComponentAst componentAst) {
        return componentAst.getModel(ThrowsErrors.class).map(model -> model.getErrorModels().isEmpty()).orElse(true);
    }

    private ErrorHandlingContext propagatedErrorHandlerContext(ComponentAst ast, ErrorHandlingContext context) {
        return this.propagatesErrorHandlingContext(ast) ? context : new ErrorHandlingContext(false);
    }

    private ChainExecutionPathTree getOperationNode(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers) {
        if (!chainComponentAst.getIdentifier().getName().equals(RAISE_ERROR)) {
            if (chainComponentAst.getIdentifier().getName().equals(FLOW_REF)) {
                Optional<ComponentParameterAst> parameter = chainComponentAst.getParameters().stream().filter(param -> param.getModel().getAllowedStereotypes().stream().anyMatch(stereotypeModel -> stereotypeModel.isAssignableTo(MuleStereotypes.FLOW) || stereotypeModel.isAssignableTo(MuleStereotypes.SUB_FLOW))).findFirst();
                Optional flowComponent = parameter.flatMap(param -> this.getTopLevelElementWithName(param.getRawValue()));
                if (flowComponent.isPresent()) {
                    return new ReferencedChainNode(chainComponentAst, (LazyValue<ChainExecutionPathTree>)new LazyValue(() -> this.generateForWithoutFlows((ComponentAst)flowComponent.get())));
                }
            } else if (chainComponentAst.getIdentifier().getNamespace().equals(BATCH_NAMESPACE)) {
                return this.createScope(chainComponentAst, errorHandlers);
            }
        }
        return new SimpleOperationNode(chainComponentAst, errorHandlers);
    }

    private ChainExecutionPathTree createScope(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers) {
        return new ScopeExecutionPathNodeBuilder(chainComponentAst).withChild(this.getNestedChainFrom(chainComponentAst, this.propagatedErrorHandlerContext(chainComponentAst, errorHandlers), false)).withErrorHandlerContext(errorHandlers).build();
    }

    private ChainExecutionPathTree createRouter(ComponentAst chainComponentAst, ErrorHandlingContext errorHandlers) {
        RouterExecutionPathNodeBuilder router = new RouterExecutionPathNodeBuilder(chainComponentAst);
        chainComponentAst.directChildren().forEach(routeChild -> router.withRoute(this.recursiveGenerateFor((ComponentAst)routeChild, this.propagatedErrorHandlerContext(chainComponentAst, errorHandlers))));
        return router.withErrorHandlerContext(errorHandlers).build();
    }
}

