/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.utils.CfgTestUtils;
import org.mule.runtime.cfg.visitors.CountingVisitor;

@Feature(value="Control Flow Graph")
@Story(value="Traversal of CFG Tree using visitor")
public class SimpleVisitingTestCase {
    @Test
    public void countOnSimpleApplication() {
        ChainExecutionPathTree tree = CfgTestUtils.testTree();
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Ignore(value="W-12450002")
    public void countOnApplicationWithErrorHandling() {
        ChainExecutionPathTree tree = CfgTestUtils.testTreeWithErrorHandling(true);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"name/1/3/0", "name/1/3/1", "name/2/1"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/2/1"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void countOnApplicationWithErrorHandlingWithNoMatchingTypes() {
        ChainExecutionPathTree tree = CfgTestUtils.testTreeWithErrorHandling(false);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"name/1/3/0", "name/1/3/1", "name/2/1"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/2/1"), (Matcher)CoreMatchers.is((Object)1));
    }
}

