/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ThrowsErrors;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.nested.HasChainExecutionOccurrence;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

class NodeUtils {
    private NodeUtils() {
    }

    private static ErrorType toErrorType(ErrorModel errorModel) {
        ErrorTypeBuilder builder = ErrorTypeBuilder.builder().identifier(errorModel.getType()).namespace(errorModel.getNamespace());
        errorModel.getParent().ifPresent(p -> builder.parentErrorType(NodeUtils.toErrorType(p)));
        return builder.build();
    }

    public static Optional<ChainExecutionPathTree> getErrorHandlers(ComponentAst componentAst, ErrorHandlingContext errorHandlers) {
        return componentAst.getModel(ThrowsErrors.class).flatMap(throwsError -> errorHandlers.getMatchingErrorHandlerFor(throwsError.getErrorModels().stream().map(NodeUtils::toErrorType).collect(Collectors.toList())));
    }

    public static boolean isChainAlwaysExecuted(ComponentAst route) {
        return route.getModel(HasChainExecutionOccurrence.class).map(HasChainExecutionOccurrence::getChainExecutionOccurrence).map(occurrence -> occurrence.equals((Object)ChainExecutionOccurrence.ONCE) || occurrence.equals((Object)ChainExecutionOccurrence.AT_LEAST_ONCE)).orElse(false);
    }
}

