/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

import java.util.Map;
import java.util.function.Predicate;

/**
 * Wraps a collection of {@link ErrorHandlerNode} for a given component in the tree, considering for which {@link ErrorType} are
 * these being called for.
 */
public class ErrorHandlerExecutionChain implements ChainExecutionPathTree {

  private final Map<ErrorType, ErrorHandlerNode> errorHandlers;

  public ErrorHandlerExecutionChain(Map<ErrorType, ErrorHandlerNode> errorHandlers) {
    this.errorHandlers = errorHandlers;
  }


  @Override
  public void accept(ChainExecutionPathTreeVisitor visitor) {
    errorHandlers.keySet().forEach(errorType -> errorHandlers.get(errorType).accept(visitor, errorType));
  }

  @Override
  public ComponentAst getComponentAst() {
    return null;
  }

  @Override
  public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
    return errorHandlers.values().stream().anyMatch(e -> e.anyExecutionPathContains(predicate));
  }

  @Override
  public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
    return errorHandlers.values().stream().allMatch(e -> e.allExecutionPathsContain(predicate));
  }
}
