/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

import java.util.List;
import java.util.function.Predicate;

/**
 * Models an ErrorHandler with all its onErrorHandlers (on-error-continue, on-error-propagate). This error handler is owned by a
 * chain.
 *
 * @since 1.5.0
 */
public class ErrorHandlerWrapperNode implements ChainExecutionPathTree {

  private final ComponentAst componentAst;
  private final List<ChainExecutionPathTree> errorHandlerNodes;

  public ErrorHandlerWrapperNode(ComponentAst componentAst, List<ChainExecutionPathTree> errorHandlerNodes) {
    this.componentAst = componentAst;
    this.errorHandlerNodes = errorHandlerNodes;
  }

  @Override
  public void accept(ChainExecutionPathTreeVisitor visitor) {
    errorHandlerNodes.forEach(handler -> handler.accept(visitor));
  }

  @Override
  public ComponentAst getComponentAst() {
    return componentAst;
  }

  @Override
  public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
    return errorHandlerNodes.stream().anyMatch(eh -> eh.anyExecutionPathContains(predicate));
  }

  @Override
  public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
    return errorHandlerNodes.stream().allMatch(eh -> eh.allExecutionPathsContain(predicate));
  }
}
