/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeFactory;
import org.mule.runtime.cfg.internal.queries.ErrorHandlingQueriesTestCase;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public final class CfgTestUtils {
    public static final ComponentIdentifier FLOW_COMP = ComponentIdentifier.buildFromStringRepresentation((String)"flow");
    public static final ComponentIdentifier SET_PAYLODAD = ComponentIdentifier.buildFromStringRepresentation((String)"set-payload");
    public static final ComponentIdentifier SET_VARIABLE = ComponentIdentifier.buildFromStringRepresentation((String)"set-variable");
    public static final ComponentIdentifier LOGGER = ComponentIdentifier.buildFromStringRepresentation((String)"logger");
    public static final ComponentIdentifier FOREACH = ComponentIdentifier.buildFromStringRepresentation((String)"foreach");
    public static final ComponentIdentifier NOOP = ComponentIdentifier.buildFromStringRepresentation((String)"noop");
    public static final ComponentIdentifier NOOP2 = ComponentIdentifier.buildFromStringRepresentation((String)"noop2");
    public static final ComponentIdentifier TRYSCOPE = ComponentIdentifier.buildFromStringRepresentation((String)"try");
    public static final ComponentIdentifier SCATTER_GATHER = ComponentIdentifier.buildFromStringRepresentation((String)"scatter-gather");
    public static final ComponentIdentifier CHOICE = ComponentIdentifier.buildFromStringRepresentation((String)"choice");
    public static final ComponentIdentifier PARALLEL_FOREACH = ComponentIdentifier.buildFromStringRepresentation((String)"parallel-foreach");
    public static final ComponentIdentifier DB_SELECT = ComponentIdentifier.builder().namespace("db").name("select").build();
    public static final ComponentIdentifier JMS_PUBLISH = ComponentIdentifier.builder().namespace("jms").name("publish").build();
    public static final ComponentIdentifier ROUTE_ELEMENT = ComponentIdentifier.buildFromStringRepresentation((String)"route");
    public static final ComponentIdentifier ERROR_HANDLER_COMPONENT = ComponentIdentifier.buildFromStringRepresentation((String)"error-handler");
    public static final ComponentIdentifier ERROR_CONTINUE = ComponentIdentifier.buildFromStringRepresentation((String)"on-error-continue");
    public static final ComponentIdentifier ERROR_PROPAGATE = ComponentIdentifier.buildFromStringRepresentation((String)"on-error-propagate");

    private CfgTestUtils() {
    }

    public static ChainExecutionPathTree testTree() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, CfgTestUtils.getExtensionModelHelper(), Collections.emptyList(), 0);
        compBuilder.withIdentifier(FLOW_COMP).withRawParameter("name", "test").withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        compBuilder.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        DefaultComponentAstBuilder foreach = (DefaultComponentAstBuilder)compBuilder.addChildComponent().withIdentifier(FOREACH).withMetadata(ComponentMetadataAst.EMPTY_METADATA).withParameterizedModel((ParameterizedModel)new MockChainModel(ChainExecutionOccurrence.ONCE_OR_NONE));
        foreach.withComponentType(TypedComponentIdentifier.ComponentType.SCOPE);
        foreach.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        ComponentAstBuilder scatter = foreach.addChildComponent().withIdentifier(SCATTER_GATHER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        scatter.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA).addChildComponent().withIdentifier(SET_PAYLODAD).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        scatter.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA).addChildComponent().withIdentifier(DB_SELECT).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        foreach.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        ComponentAstBuilder choice = compBuilder.addChildComponent().withIdentifier(CHOICE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        choice.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA).addChildComponent().withIdentifier(SET_PAYLODAD).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        ComponentAstBuilder otherwiseRoute = choice.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        otherwiseRoute.addChildComponent().withIdentifier(SET_VARIABLE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        otherwiseRoute.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        DefaultComponentAstBuilder tryscope = (DefaultComponentAstBuilder)compBuilder.addChildComponent().withIdentifier(TRYSCOPE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        tryscope.withComponentType(TypedComponentIdentifier.ComponentType.SCOPE).withParameterizedModel((ParameterizedModel)new MockChainModel(ChainExecutionOccurrence.ONCE)).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        tryscope.addChildComponent().withIdentifier(NOOP).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        return new ChainExecutionPathTreeFactory((ArtifactAst)Mockito.mock(ArtifactAst.class)).generateFor(compBuilder.build());
    }

    private static DefaultExtensionModelHelper getExtensionModelHelper() {
        DefaultExtensionModelHelper helper = (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class);
        Mockito.when((Object)helper.findComponentType((ComponentIdentifier)ArgumentMatchers.any(ComponentIdentifier.class))).thenAnswer(invocationOnMock -> {
            ComponentIdentifier identifier = (ComponentIdentifier)invocationOnMock.getArgument(0);
            if (identifier.equals(FLOW_COMP)) {
                return TypedComponentIdentifier.ComponentType.FLOW;
            }
            if (identifier.equals(FOREACH) || identifier.equals(TRYSCOPE) || identifier.equals(PARALLEL_FOREACH)) {
                return TypedComponentIdentifier.ComponentType.SCOPE;
            }
            if (identifier.equals(CHOICE) || identifier.equals(SCATTER_GATHER)) {
                return TypedComponentIdentifier.ComponentType.ROUTER;
            }
            if (identifier.equals(ROUTE_ELEMENT)) {
                return TypedComponentIdentifier.ComponentType.ROUTE;
            }
            if (identifier.equals(ERROR_HANDLER_COMPONENT)) {
                return TypedComponentIdentifier.ComponentType.ERROR_HANDLER;
            }
            if (identifier.equals(ERROR_CONTINUE) || identifier.equals(ERROR_PROPAGATE)) {
                return TypedComponentIdentifier.ComponentType.ON_ERROR;
            }
            return TypedComponentIdentifier.ComponentType.OPERATION;
        });
        return helper;
    }

    public static ChainExecutionPathTree testTreeWithErrorHandling(boolean continueWithAllErrors) {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        DefaultComponentAstBuilder compBuilder = new DefaultComponentAstBuilder(propertiesResolver, CfgTestUtils.getExtensionModelHelper(), Collections.emptyList(), 0);
        compBuilder.withIdentifier(FLOW_COMP).withRawParameter("name", "test").withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        CfgTestUtils.addFlowNameParameter(compBuilder);
        compBuilder.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        DefaultComponentAstBuilder tryScope = (DefaultComponentAstBuilder)compBuilder.addChildComponent().withIdentifier(TRYSCOPE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        tryScope.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        ComponentAstBuilder choice = tryScope.addChildComponent().withIdentifier(CHOICE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        choice.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA).addChildComponent().withIdentifier(SET_PAYLODAD).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        DefaultComponentAstBuilder select = (DefaultComponentAstBuilder)choice.addChildComponent().withIdentifier(ROUTE_ELEMENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA).addChildComponent().withIdentifier(DB_SELECT).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        CfgTestUtils.addErrors(select, "SOME", "OTHER");
        select.withComponentType(TypedComponentIdentifier.ComponentType.OPERATION);
        tryScope.addChildComponent().withIdentifier(LOGGER).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        DefaultComponentAstBuilder errorHandler = (DefaultComponentAstBuilder)tryScope.addChildComponent().withIdentifier(ERROR_HANDLER_COMPONENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        CfgTestUtils.addErrorHandlerParameterizedModel(errorHandler);
        DefaultComponentAstBuilder propagateEH = (DefaultComponentAstBuilder)errorHandler.addChildComponent().withIdentifier(ERROR_PROPAGATE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        CfgTestUtils.addErrorHandlingType(propagateEH, "TEST:SOME");
        propagateEH.addChildComponent().withIdentifier(SET_VARIABLE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        propagateEH.addChildComponent().withIdentifier(JMS_PUBLISH).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        propagateEH.addChildComponent().withIdentifier(NOOP).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        propagateEH.withComponentType(TypedComponentIdentifier.ComponentType.ON_ERROR);
        DefaultComponentAstBuilder continueEH = (DefaultComponentAstBuilder)errorHandler.addChildComponent().withIdentifier(ERROR_CONTINUE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.addChildComponent().withIdentifier(SET_VARIABLE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.withComponentType(TypedComponentIdentifier.ComponentType.ON_ERROR);
        CfgTestUtils.addErrorHandlingType(continueEH, continueWithAllErrors ? null : "TEST:OTHER");
        errorHandler = (DefaultComponentAstBuilder)compBuilder.addChildComponent().withIdentifier(ERROR_HANDLER_COMPONENT).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        CfgTestUtils.addErrorHandlerParameterizedModel(errorHandler);
        continueEH = (DefaultComponentAstBuilder)errorHandler.addChildComponent().withIdentifier(ERROR_CONTINUE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.addChildComponent().withIdentifier(NOOP2).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.withComponentType(TypedComponentIdentifier.ComponentType.ON_ERROR);
        CfgTestUtils.addErrorHandlingType(continueEH, "MULE:NOTHING");
        continueEH = (DefaultComponentAstBuilder)errorHandler.addChildComponent().withIdentifier(ERROR_CONTINUE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.addChildComponent().withIdentifier(SET_VARIABLE).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        continueEH.withComponentType(TypedComponentIdentifier.ComponentType.ON_ERROR);
        CfgTestUtils.addErrorHandlingType(continueEH, null);
        return new ChainExecutionPathTreeFactory(CfgTestUtils.getApplication()).generateFor(compBuilder.build());
    }

    private static ParameterGroupModel createMockParameterGroup() {
        ParameterGroupModel groupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)groupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)groupModel.getParameterModels()).thenReturn(Collections.emptyList());
        return groupModel;
    }

    private static void addErrorHandlerParameterizedModel(DefaultComponentAstBuilder builder) {
        ParameterizedModel model = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        builder.withParameterizedModel(model);
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(CfgTestUtils.class.getClassLoader());
        MetadataType stringType = typeLoader.load(String.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"ref");
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)stringType);
        Mockito.when((Object)parameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)parameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.NOT_SUPPORTED);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.singletonList(MuleStereotypes.ERROR_HANDLER));
        ParameterGroupModel defaultGroup = CfgTestUtils.createMockParameterGroup();
        Mockito.when((Object)defaultGroup.getParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)defaultGroup.getParameter("ref")).thenReturn(Optional.of(parameterModel));
        Mockito.when((Object)model.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)model.getParameterGroupModels()).thenReturn(Collections.singletonList(defaultGroup));
        builder.withComponentType(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
    }

    private static void addErrorHandlingType(DefaultComponentAstBuilder errorhandler, String type) {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(ErrorHandlingQueriesTestCase.class.getClassLoader());
        MetadataType stringType = typeLoader.load(String.class);
        ParameterModel typeModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)typeModel.getName()).thenReturn((Object)"type");
        Mockito.when((Object)typeModel.getType()).thenReturn((Object)stringType);
        ParameterGroupModel defaultGroup = CfgTestUtils.createMockParameterGroup();
        errorhandler.withParameter(typeModel, defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst(type, typeModel, defaultGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver()), Optional.empty());
        ParameterizedModel parameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterized.getAllParameterModels()).thenReturn(Collections.singletonList(typeModel));
        Mockito.when((Object)parameterized.getParameterGroupModels()).thenReturn(Collections.singletonList(defaultGroup));
        errorhandler.withParameterizedModel(parameterized);
    }

    private static void addErrors(DefaultComponentAstBuilder builder, String ... errors) {
        OperationModel model = (OperationModel)Mockito.mock(OperationModel.class);
        HashSet<ImmutableErrorModel> errorsModels = new HashSet<ImmutableErrorModel>();
        ImmutableErrorModel universalParent = new ImmutableErrorModel("ANY", "MULE", true, null);
        for (String err : errors) {
            errorsModels.add(new ImmutableErrorModel(err, "TEST", true, (ErrorModel)universalParent));
        }
        Mockito.when((Object)model.getErrorModels()).thenReturn(errorsModels);
        builder.withComponentModel((ComponentModel)model);
    }

    private static ArtifactAst getApplication() {
        ArtifactAst application = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ErrorTypeRepository repository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        ErrorType parent = ErrorTypeBuilder.builder().identifier("ANY").namespace("MULE").build();
        Mockito.when((Object)repository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            ComponentIdentifier identifier = (ComponentIdentifier)invocationOnMock.getArgument(0);
            ErrorTypeBuilder builder = ErrorTypeBuilder.builder().identifier(identifier.getName()).namespace(identifier.getNamespace());
            if (!identifier.getName().equals("ANY") || !identifier.getNamespace().equals("MULE")) {
                builder.parentErrorType(parent);
            }
            return Optional.of(builder.build());
        });
        Mockito.when((Object)application.getErrorTypeRepository()).thenReturn((Object)repository);
        return application;
    }

    private static void addFlowNameParameter(DefaultComponentAstBuilder builder) {
        ParameterizedModel model = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        builder.withParameterizedModel(model);
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(CfgTestUtils.class.getClassLoader());
        MetadataType stringType = typeLoader.load(String.class);
        ParameterModel flatParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)flatParameterModel.getName()).thenReturn((Object)"flowName");
        Mockito.when((Object)flatParameterModel.getType()).thenReturn((Object)stringType);
        Mockito.when((Object)flatParameterModel.isComponentId()).thenReturn((Object)true);
        Mockito.when((Object)model.getAllParameterModels()).thenReturn(Collections.singletonList(flatParameterModel));
        ParameterGroupModel defaultGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)defaultGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)defaultGroup.getName()).thenReturn((Object)"Default");
        Mockito.when((Object)defaultGroup.getParameterModels()).thenReturn(Collections.singletonList(flatParameterModel));
        Mockito.when((Object)defaultGroup.getParameter("flowName")).thenReturn(Optional.of(flatParameterModel));
        builder.withParameter(flatParameterModel, defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst("name", flatParameterModel, defaultGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver()), Optional.empty());
        builder.withComponentType(TypedComponentIdentifier.ComponentType.FLOW);
    }

    public static boolean hasIdentifier(ChainExecutionPathTree tree, ComponentIdentifier identifier) {
        return tree.getComponentAst().getIdentifier().equals(identifier);
    }

    private static class MockChainModel
    implements NestedChainModel {
        private final ChainExecutionOccurrence occurrence;

        public MockChainModel(ChainExecutionOccurrence occurrence) {
            this.occurrence = occurrence;
        }

        public boolean isRequired() {
            return false;
        }

        public Set<StereotypeModel> getAllowedStereotypes() {
            return null;
        }

        public int getMinOccurs() {
            return 1;
        }

        public Optional<Integer> getMaxOccurs() {
            return Optional.of(1);
        }

        public void accept(NestableElementModelVisitor visitor) {
        }

        public void accept(ComponentModelVisitor visitor) {
        }

        public ComponentVisibility getVisibility() {
            return null;
        }

        public List<? extends NestableElementModel> getNestedComponents() {
            return Collections.emptyList();
        }

        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return Optional.empty();
        }

        public Set<ModelProperty> getModelProperties() {
            return Collections.emptySet();
        }

        public Optional<DeprecationModel> getDeprecationModel() {
            return Optional.empty();
        }

        public Optional<DisplayModel> getDisplayModel() {
            return Optional.empty();
        }

        public Set<ErrorModel> getErrorModels() {
            return Collections.emptySet();
        }

        public ChainExecutionOccurrence getChainExecutionOccurrence() {
            return this.occurrence;
        }

        public List<ParameterGroupModel> getParameterGroupModels() {
            return Collections.emptyList();
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return null;
        }

        public StereotypeModel getStereotype() {
            return null;
        }

        public Optional<MuleVersion> getMinMuleVersion() {
            return Optional.empty();
        }
    }
}

