/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerNode;

public class ErrorHandlingExecutionPathNodeBuilder {
    private ComponentAst componentAst;
    private Optional<ChainExecutionPathTree> child = Optional.empty();
    private Optional<ErrorTypeMatcher> errorMatch = Optional.empty();

    public ErrorHandlingExecutionPathNodeBuilder(ComponentAst ast) {
        this.componentAst = ast;
    }

    public ErrorHandlingExecutionPathNodeBuilder setChild(ChainExecutionPathTree child) {
        this.child = Optional.of(child);
        return this;
    }

    public ErrorHandlingExecutionPathNodeBuilder setErrorMatcher(ErrorTypeMatcher errorExpression) {
        this.errorMatch = Optional.of(errorExpression);
        return this;
    }

    public ErrorHandlerNode build() {
        return new ErrorHandlingImplNode(this.componentAst, this.child, this.errorMatch);
    }

    private static class ErrorHandlingImplNode
    implements ErrorHandlerNode {
        private final ComponentAst componentAst;
        private final Optional<ChainExecutionPathTree> child;
        private final Optional<ErrorTypeMatcher> errorMatch;
        private List<Pair<ErrorHandlerNode, Set<ErrorType>>> outers = new ArrayList<Pair<ErrorHandlerNode, Set<ErrorType>>>();

        private ErrorHandlingImplNode(ComponentAst componentAst, Optional<ChainExecutionPathTree> child, Optional<ErrorTypeMatcher> errorMatch) {
            this.componentAst = componentAst;
            this.child = child;
            this.errorMatch = errorMatch;
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return predicate.test(this) || this.child.map(c -> c.anyExecutionPathContains(predicate)).orElse(false) != false;
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return predicate.test(this) || this.child.map(c -> c.allExecutionPathsContain(predicate)).orElse(true) != false;
        }

        @Override
        public boolean appliesTo(ErrorType errorType) {
            return this.errorMatch.map(em -> em.match(errorType)).orElse(true);
        }

        @Override
        public void setOuters(List<ErrorHandlerNode> outer) {
            this.outers = outer.stream().map(o -> new Pair(o, new HashSet())).collect(Collectors.toList());
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor, ErrorType incoming) {
            visitor.errorHandlerCouldBeInvoked(this, incoming);
            this.outers.stream().filter(outer -> ((ErrorHandlerNode)outer.getFirst()).appliesTo(incoming)).findFirst().ifPresent(outer -> ((Set)outer.getSecond()).add(incoming));
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor) {
            if (!visitor.errorHandlerStarted(this)) {
                return;
            }
            this.child.ifPresent(c -> c.accept(visitor));
            visitor.errorHandlerFinished(this);
            this.outers.forEach(outer -> ((Set)outer.getSecond()).forEach(errorType -> visitor.errorHandlerCouldBeInvoked((ChainExecutionPathTree)outer.getFirst(), (ErrorType)errorType)));
            visitor.errorHandlerPropagationComplete(this);
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.componentAst;
        }

        @Override
        public List<ChainExecutionPathTree> children() {
            return this.child.map(Collections::singletonList).orElse(Collections.emptyList());
        }
    }
}

