/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node.errorhandling;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

import java.util.List;

/**
 * Models an ErrorHandler (e.g. on-error-propagate, on-error-continue).
 * 
 * @since 1.1
 */
public interface ErrorHandlerNode extends ChainExecutionPathTree, InterruptionCapableNode {

  /**
   * @param errorType
   * @return indicates if this {@link ErrorHandlerNode} matches the given {@param errorType}.
   */
  boolean appliesTo(ErrorType errorType);

  /**
   * @return indicates if this {@link ErrorHandlerNode} causes the errors to be recovered from.
   */
  boolean isContinueHandler();

  /**
   * Sets the outer Error Handlers to this handler. This sets all the possible handlers to delegate the error after all the inner
   * nodes of this chain have been executed.
   * 
   * @param outer a list of {@link ErrorTypeMatcher}-{@link ErrorHandlerNode}, ordered by the execution precedence. After
   *              processing an error, the first node which its matcher corresponds to the error type, should be executed.
   */
  void setOuters(List<ErrorHandlerNode> outer);

  /**
   * Navigates this tree, similarly to
   * {@link org.mule.runtime.cfg.api.ChainExecutionPathTree#accept(ChainExecutionPathTreeVisitor)}. This also receives the error
   * that may involve the execution of the error handler.
   * 
   * @param visitor
   * @param errorType
   */
  void accept(ChainExecutionPathTreeVisitor visitor, ErrorType errorType);

  /**
   * @return the {@link ComponentAst} that this node of the tree represents.
   */
  ComponentAst getComponentAst();

}
