/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class MockChainBuilder {
    private static final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MockChainBuilder.class.getClassLoader());
    private static final MetadataType STRING_TYPE = TYPE_LOADER.load(String.class);
    private static final ComponentIdentifier FLOW_COMP = ComponentIdentifier.buildFromStringRepresentation((String)"flow");
    private static final ComponentIdentifier FLOW_REF = ComponentIdentifier.buildFromStringRepresentation((String)"flow-ref");
    private static final ComponentIdentifier ROUTE_ELEMENT = ComponentIdentifier.buildFromStringRepresentation((String)"route");
    private static final ComponentIdentifier ERROR_HANDLER_COMPONENT = ComponentIdentifier.buildFromStringRepresentation((String)"error-handler");
    private static final ComponentIdentifier ERROR_CONTINUE = ComponentIdentifier.buildFromStringRepresentation((String)"on-error-continue");
    private static final ComponentIdentifier ERROR_PROPAGATE = ComponentIdentifier.buildFromStringRepresentation((String)"on-error-propagate");
    public static final ComponentIdentifier RAISE_ERROR = ComponentIdentifier.buildFromStringRepresentation((String)"raise-error");
    private final ComponentAstBuilder delegate;

    public static MockChainBuilder newBuilder(String flowName) {
        return new MockChainBuilder(MockChainBuilder.getFlowBuilder(flowName));
    }

    private MockChainBuilder(ComponentAstBuilder delegate) {
        this.delegate = delegate;
    }

    private static ComponentAstBuilder getFlowBuilder(String flowName) {
        DefaultComponentAstBuilder flowBuilder = new DefaultComponentAstBuilder(new PropertiesResolver(), (ExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class), Collections.emptyList(), 0, new ComponentLocationVisitor(), new ParameterModelUtils());
        flowBuilder.withIdentifier(FLOW_COMP).withRawParameter("name", flowName).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        MockChainBuilder.addStringParameter(flowBuilder, "flowName", flowName, true, ExpressionSupport.NOT_SUPPORTED, Collections.emptyList());
        flowBuilder.withComponentType(TypedComponentIdentifier.ComponentType.FLOW);
        return flowBuilder;
    }

    public MockChainBuilder addSimpleOperation(ComponentIdentifier componentIdentifier) {
        this.addChildComponentBuilder(componentIdentifier, TypedComponentIdentifier.ComponentType.OPERATION);
        return this;
    }

    public MockChainBuilder addSimpleOperationWithErrors(ComponentIdentifier componentIdentifier, String ... errors) {
        DefaultComponentAstBuilder componentAstBuilder = this.addChildComponentBuilder(componentIdentifier, TypedComponentIdentifier.ComponentType.OPERATION);
        MockChainBuilder.addErrors(componentAstBuilder, errors);
        return this;
    }

    public MockChainBuilder addRaiseError(String errorType) {
        DefaultComponentAstBuilder builder = this.addChildComponentBuilder(RAISE_ERROR, TypedComponentIdentifier.ComponentType.OPERATION);
        MockChainBuilder.addStringParameter(builder, "type", errorType, false, ExpressionSupport.NOT_SUPPORTED, Collections.emptyList());
        return this;
    }

    public MockChainBuilder addFlowRef(String name) {
        DefaultComponentAstBuilder builder = this.addChildComponentBuilder(FLOW_REF, TypedComponentIdentifier.ComponentType.OPERATION);
        MockChainBuilder.addStringParameter(builder, "name", name, false, ExpressionSupport.SUPPORTED, Arrays.asList(MuleStereotypes.FLOW, MuleStereotypes.SUB_FLOW));
        return this;
    }

    public MockChainBuilder addScope(ComponentIdentifier componentIdentifier, ChainExecutionOccurrence chainExecutionOccurrence, Consumer<MockChainBuilder> chainConfigurer) {
        BaseComponentAstBuilder builder = this.addChildComponentBuilder(componentIdentifier, TypedComponentIdentifier.ComponentType.SCOPE).withParameterizedModel((ParameterizedModel)new MockChainModel(chainExecutionOccurrence));
        chainConfigurer.accept(new MockChainBuilder((ComponentAstBuilder)builder));
        return this;
    }

    public MockChainBuilder addRouter(ComponentIdentifier componentIdentifier, Consumer<MockChainBuilder> routerConfigurer) {
        DefaultComponentAstBuilder builder = this.addChildComponentBuilder(componentIdentifier, TypedComponentIdentifier.ComponentType.ROUTER);
        routerConfigurer.accept(new MockChainBuilder((ComponentAstBuilder)builder));
        return this;
    }

    public MockChainBuilder addRoute(ChainExecutionOccurrence chainExecutionOccurrence, Consumer<MockChainBuilder> chainConfigurer) {
        BaseComponentAstBuilder builder = this.addChildComponentBuilder(ROUTE_ELEMENT, TypedComponentIdentifier.ComponentType.ROUTE).withParameterizedModel((ParameterizedModel)new MockChainModel(chainExecutionOccurrence));
        chainConfigurer.accept(new MockChainBuilder((ComponentAstBuilder)builder));
        return this;
    }

    public MockChainBuilder addErrorHandler(Consumer<MockChainBuilder> chainConfigurer) {
        DefaultComponentAstBuilder errorHandler = this.addChildComponentBuilder(ERROR_HANDLER_COMPONENT, TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
        MockChainBuilder.addStringParameter(errorHandler, "ref", null, true, ExpressionSupport.NOT_SUPPORTED, Collections.singletonList(MuleStereotypes.ERROR_HANDLER));
        chainConfigurer.accept(new MockChainBuilder((ComponentAstBuilder)errorHandler));
        return this;
    }

    public MockChainBuilder addOnErrorPropagate(String type, Consumer<MockChainBuilder> chainConfigurer) {
        return this.addOnError(ERROR_PROPAGATE, type, chainConfigurer);
    }

    public MockChainBuilder addOnErrorContinue(String type, Consumer<MockChainBuilder> chainConfigurer) {
        return this.addOnError(ERROR_CONTINUE, type, chainConfigurer);
    }

    private MockChainBuilder addOnError(ComponentIdentifier componentIdentifier, String type, Consumer<MockChainBuilder> chainConfigurer) {
        DefaultComponentAstBuilder propagateEH = this.addChildComponentBuilder(componentIdentifier, TypedComponentIdentifier.ComponentType.ON_ERROR);
        MockChainBuilder.addStringParameter(propagateEH, "type", type, false, ExpressionSupport.NOT_SUPPORTED, Collections.emptyList());
        chainConfigurer.accept(new MockChainBuilder((ComponentAstBuilder)propagateEH));
        return this;
    }

    public ComponentAst build() {
        return this.delegate.build();
    }

    private DefaultComponentAstBuilder addChildComponentBuilder(ComponentIdentifier identifier, TypedComponentIdentifier.ComponentType componentType) {
        DefaultComponentAstBuilder componentBuilder = (DefaultComponentAstBuilder)this.delegate.addChildComponent().withIdentifier(identifier).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        componentBuilder.withComponentType(componentType);
        return componentBuilder;
    }

    private static ParameterGroupModel createMockParameterGroup(ParameterModel parameterModel) {
        ParameterGroupModel groupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)groupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)groupModel.getParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)groupModel.getParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)groupModel.getParameter(parameterModel.getName())).thenReturn(Optional.of(parameterModel));
        return groupModel;
    }

    private static void addErrors(DefaultComponentAstBuilder builder, String ... errors) {
        OperationModel model = (OperationModel)Mockito.mock(OperationModel.class);
        HashSet<ImmutableErrorModel> errorsModels = new HashSet<ImmutableErrorModel>();
        ImmutableErrorModel universalParent = new ImmutableErrorModel("ANY", "MULE", true, null);
        for (String err : errors) {
            errorsModels.add(new ImmutableErrorModel(err, "TEST", true, (ErrorModel)universalParent));
        }
        Mockito.when((Object)model.getErrorModels()).thenReturn(errorsModels);
        builder.withComponentModel((ComponentModel)model);
    }

    private static void addStringParameter(DefaultComponentAstBuilder componentBuilder, String paramName, String paramValue, boolean isComponentId, ExpressionSupport expressionSupport, List<StereotypeModel> allowedStereotypes) {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)paramName);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)STRING_TYPE);
        Mockito.when((Object)parameterModel.isComponentId()).thenReturn((Object)isComponentId);
        Mockito.when((Object)parameterModel.getExpressionSupport()).thenReturn((Object)expressionSupport);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(allowedStereotypes);
        ParameterGroupModel defaultGroup = MockChainBuilder.createMockParameterGroup(parameterModel);
        if (paramValue != null) {
            componentBuilder.withParameter(parameterModel, defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst(paramValue, parameterModel, defaultGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        }
        ParameterizedModel parameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterized.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)parameterized.getParameterGroupModels()).thenReturn(Collections.singletonList(defaultGroup));
        componentBuilder.withParameterizedModel(parameterized);
    }

    private static class MockChainModel
    implements NestedChainModel {
        private final ChainExecutionOccurrence occurrence;

        public MockChainModel(ChainExecutionOccurrence occurrence) {
            this.occurrence = occurrence;
        }

        public boolean isRequired() {
            return false;
        }

        public Set<StereotypeModel> getAllowedStereotypes() {
            return null;
        }

        public int getMinOccurs() {
            return 1;
        }

        public Optional<Integer> getMaxOccurs() {
            return Optional.of(1);
        }

        public void accept(NestableElementModelVisitor visitor) {
        }

        public void accept(ComponentModelVisitor visitor) {
        }

        public ComponentVisibility getVisibility() {
            return null;
        }

        public List<? extends NestableElementModel> getNestedComponents() {
            return Collections.emptyList();
        }

        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return Optional.empty();
        }

        public Set<ModelProperty> getModelProperties() {
            return Collections.emptySet();
        }

        public Optional<DeprecationModel> getDeprecationModel() {
            return Optional.empty();
        }

        public Optional<DisplayModel> getDisplayModel() {
            return Optional.empty();
        }

        public Set<ErrorModel> getErrorModels() {
            return Collections.emptySet();
        }

        public ChainExecutionOccurrence getChainExecutionOccurrence() {
            return this.occurrence;
        }

        public List<ParameterGroupModel> getParameterGroupModels() {
            return Collections.emptyList();
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return null;
        }

        public StereotypeModel getStereotype() {
            return null;
        }

        public Optional<MuleVersion> getMinMuleVersion() {
            return Optional.empty();
        }
    }
}

