/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.NodeUtils;
import org.mule.runtime.cfg.internal.node.NullNode;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlerWrapperNode;
import org.mule.runtime.cfg.internal.node.errorhandling.InterruptionCapableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedExecutionPathNodeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainedExecutionPathNodeBuilder.class);
    private final ComponentAst chainAst;
    private ComponentModel ownerModel;
    private ChainNode first;
    private ChainNode last;
    private final List<ChainExecutionPathTree> children = new ArrayList<ChainExecutionPathTree>();
    private Optional<ErrorHandlerWrapperNode> ownedErrorHandler = Optional.empty();

    public ChainedExecutionPathNodeBuilder(ComponentAst chainAst) {
        this.chainAst = chainAst;
    }

    public void withOwnerModel(ComponentModel ownerModel) {
        this.ownerModel = ownerModel;
    }

    public ChainedExecutionPathNodeBuilder addChild(ChainExecutionPathTree child) {
        this.children.add(child);
        ChainNode newNode = new ChainNode(child);
        if (this.first == null) {
            this.first = newNode;
        } else {
            this.last.next = Optional.of(newNode);
        }
        this.last = newNode;
        return this;
    }

    public ChainedExecutionPathNodeBuilder addOwnedErrorHandler(ErrorHandlerWrapperNode errorHandler) {
        this.ownedErrorHandler = Optional.of(errorHandler);
        return this;
    }

    public ChainExecutionPathTree build() {
        return new HeadNode(this.ownerModel, this.chainAst, this.first != null ? this.first : new ChainNode(NullNode.getInstance()), this.children, this.ownedErrorHandler);
    }

    private static class ChainNode
    implements ChainExecutionPathTree,
    InterruptionCapableNode {
        private ChainExecutionPathTree owningChain;
        private final ChainExecutionPathTree delegate;
        public Optional<ChainNode> next = Optional.empty();

        private ChainNode(ChainExecutionPathTree delegate) {
            this.delegate = delegate;
        }

        public void setOwningChain(ChainExecutionPathTree owningChain) {
            this.owningChain = owningChain;
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor) {
            LOGGER.debug("Visiting '{}'...", (Object)this.delegate.getComponentAst());
            this.delegate.accept(visitor);
            if (NodeUtils.alwaysInterruptsWithError(this.delegate).isPresent()) {
                visitor.chainInterruptedWithError(this.owningChain);
            } else {
                this.next.ifPresent(node -> node.accept(visitor));
            }
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.delegate.getComponentAst();
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return this.delegate.anyExecutionPathContains(predicate) || this.getNext().map(node -> node.anyExecutionPathContains(predicate)).orElse(false) != false;
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return this.delegate.allExecutionPathsContain(predicate) || this.getNext().map(node -> node.allExecutionPathsContain(predicate)).orElse(false) != false;
        }

        @Override
        public Optional<ErrorType> alwaysInterruptsWithError() {
            Optional<ErrorType> ownErrorType = NodeUtils.alwaysInterruptsWithError(this.delegate);
            if (ownErrorType.isPresent()) {
                return ownErrorType;
            }
            return this.next.flatMap(ChainNode::alwaysInterruptsWithError);
        }

        private Optional<ChainNode> getNext() {
            return NodeUtils.alwaysInterruptsWithError(this.delegate).isPresent() ? Optional.empty() : this.next;
        }
    }

    private static class HeadNode
    implements ChainExecutionPathTree,
    InterruptionCapableNode {
        private final ComponentModel ownerModel;
        private final ComponentAst chainAst;
        private final ChainNode firstNode;
        private final List<ChainExecutionPathTree> children;
        private final Optional<ErrorHandlerWrapperNode> errorHandlingAfterChain;
        private final LazyValue<Optional<ErrorType>> alwaysInterruptsWithError;

        public HeadNode(ComponentModel ownerModel, ComponentAst chainAst, ChainNode firstNode, List<ChainExecutionPathTree> children, Optional<ErrorHandlerWrapperNode> errorHandlingAfterChain) {
            this.ownerModel = ownerModel;
            this.chainAst = chainAst;
            this.firstNode = firstNode;
            this.children = children;
            this.errorHandlingAfterChain = errorHandlingAfterChain;
            this.alwaysInterruptsWithError = new LazyValue(this::computeAlwaysInterruptsWithError);
            this.setOwningChainToChildNodes();
        }

        @Override
        public void accept(ChainExecutionPathTreeVisitor visitor) {
            this.firstNode.accept(visitor);
            this.errorHandlingAfterChain.ifPresent(errorHandler -> errorHandler.accept(visitor));
        }

        @Override
        public Optional<ComponentModel> getOwnerModel() {
            return Optional.of(this.ownerModel);
        }

        @Override
        public ComponentAst getComponentAst() {
            return this.chainAst;
        }

        @Override
        public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
            return this.firstNode.anyExecutionPathContains(predicate);
        }

        @Override
        public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
            return this.firstNode.allExecutionPathsContain(predicate);
        }

        @Override
        public List<ChainExecutionPathTree> children() {
            return Collections.unmodifiableList(this.children);
        }

        @Override
        public Optional<ErrorType> alwaysInterruptsWithError() {
            return (Optional)this.alwaysInterruptsWithError.get();
        }

        private Optional<ErrorType> computeAlwaysInterruptsWithError() {
            Optional<ErrorType> chainError = this.firstNode.alwaysInterruptsWithError();
            if (chainError.isPresent() && this.errorHandlingAfterChain.isPresent()) {
                return this.errorHandlingAfterChain.flatMap(ehChain -> ehChain.transformsThisErrorTo((ErrorType)chainError.get()));
            }
            return chainError;
        }

        private void setOwningChainToChildNodes() {
            Optional<ChainNode> node = Optional.ofNullable(this.firstNode);
            while (node.isPresent()) {
                node.get().setOwningChain(this);
                node = node.get().next;
            }
        }
    }
}

