/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.AbstractWithErrorsNode;
import org.mule.runtime.cfg.internal.node.NodeUtils;
import org.mule.runtime.cfg.internal.node.errorhandling.ErrorHandlingContext;

public class SimpleOperationNode
extends AbstractWithErrorsNode {
    private static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();
    private final ComponentAst componentAst;
    private final Optional<ErrorType> interruptsExecution;

    public SimpleOperationNode(ComponentAst componentAst, ErrorHandlingContext errorHandlers, ErrorTypeRepository errorTypeRepository) {
        super(SimpleOperationNode.getErrorHandlers(componentAst, errorHandlers, errorTypeRepository));
        this.componentAst = componentAst;
        this.interruptsExecution = SimpleOperationNode.getErrorTypeFromRaiseError(componentAst, errorTypeRepository);
    }

    @Override
    protected void doAccept(ChainExecutionPathTreeVisitor visitor) {
        visitor.visitSimpleOperation(this);
    }

    @Override
    public ComponentAst getComponentAst() {
        return this.componentAst;
    }

    @Override
    public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
        return predicate.test(this) || this.anyErrorHandlerExecutionPathContains(predicate);
    }

    @Override
    public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
        return predicate.test(this);
    }

    @Override
    public Optional<ErrorType> alwaysInterruptsWithError() {
        return this.interruptsExecution;
    }

    private static boolean isRaiseError(ComponentAst componentAst) {
        return RAISE_ERROR_IDENTIFIER.equals(componentAst.getIdentifier());
    }

    private static ErrorType getErrorTypeFromString(String errorTypeStr, ErrorTypeRepository errorTypeRepository) {
        ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)errorTypeStr);
        return errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElse(new IncorrectNameErrorType());
    }

    private static Optional<ErrorType> getErrorTypeFromRaiseError(ComponentAst componentAst, ErrorTypeRepository errorTypeRepository) {
        if (!SimpleOperationNode.isRaiseError(componentAst)) {
            return Optional.empty();
        }
        ComponentParameterAst typeParameter = componentAst.getParameter("General", "type");
        Object typeParameterValue = typeParameter.getValue().getRight();
        return typeParameterValue instanceof String ? Optional.of(SimpleOperationNode.getErrorTypeFromString((String)typeParameterValue, errorTypeRepository)) : Optional.empty();
    }

    public static Optional<ChainExecutionPathTree> getErrorHandlers(ComponentAst componentAst, ErrorHandlingContext errorHandlers, ErrorTypeRepository errorTypeRepository) {
        Optional<ChainExecutionPathTree> errorHandlersFromRaiseError = SimpleOperationNode.getErrorTypeFromRaiseError(componentAst, errorTypeRepository).flatMap(et -> errorHandlers.getMatchingErrorHandlerFor(Collections.singletonList(et)));
        if (errorHandlersFromRaiseError.isPresent()) {
            return errorHandlersFromRaiseError;
        }
        return NodeUtils.getErrorHandlers(componentAst, errorHandlers);
    }

    private static final class IncorrectNameErrorType
    implements ErrorType {
        private IncorrectNameErrorType() {
        }

        public String getIdentifier() {
            return "Incorrect";
        }

        public String getNamespace() {
            return "Undefined";
        }

        public ErrorType getParentErrorType() {
            return null;
        }
    }
}

