/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.utils.CfgTestUtils;
import org.mule.runtime.cfg.visitors.AllExecutionPathsVisitor;

@Feature(value="Control Flow Graph")
@Story(value="Traversal of CFG Tree using visitor")
public class AllPathsTestCase {
    private static final String LOGGER_CMP = "logger";
    private static final String FOREACH_CMP = "foreach";
    private static final String SCATTER_GATHER_CMP = "scatter-gather";
    private static final String SELECT_CMP = "db:select";
    private static final String CHOICE_CMP = "choice";
    private static final String SET_VARIABLE_CMP = "set-variable";
    private static final String SET_PAYLOAD_CMP = "set-payload";
    private static final String TRY_CMP = "try";
    private static final String NOOP_CMP = "noop";

    @Test
    public void visitOnSimpleApplication() {
        ChainExecutionPathTree tree = CfgTestUtils.testTree();
        AllExecutionPathsVisitor visitor = new AllExecutionPathsVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        List<List<ComponentAst>> possibleExecutions = visitor.getAllPossibleExecutions();
        MatcherAssert.assertThat(possibleExecutions, (Matcher)Matchers.hasSize((int)4));
        List identifiers = possibleExecutions.stream().map(l -> l.stream().map(comp -> comp.getIdentifier().toString()).collect(Collectors.toList())).collect(Collectors.toList());
        MatcherAssert.assertThat(identifiers, (Matcher)new AnySubCollectionIs(LOGGER_CMP, FOREACH_CMP, LOGGER_CMP, SCATTER_GATHER_CMP, SELECT_CMP, LOGGER_CMP, CHOICE_CMP, SET_VARIABLE_CMP, LOGGER_CMP, TRY_CMP, NOOP_CMP));
        MatcherAssert.assertThat(identifiers, (Matcher)new AnySubCollectionIs(LOGGER_CMP, FOREACH_CMP, LOGGER_CMP, SCATTER_GATHER_CMP, SELECT_CMP, LOGGER_CMP, CHOICE_CMP, SET_PAYLOAD_CMP, TRY_CMP, NOOP_CMP));
        MatcherAssert.assertThat(identifiers, (Matcher)new AnySubCollectionIs(LOGGER_CMP, FOREACH_CMP, LOGGER_CMP, SCATTER_GATHER_CMP, SET_PAYLOAD_CMP, LOGGER_CMP, CHOICE_CMP, SET_VARIABLE_CMP, LOGGER_CMP, TRY_CMP, NOOP_CMP));
        MatcherAssert.assertThat(identifiers, (Matcher)new AnySubCollectionIs(LOGGER_CMP, FOREACH_CMP, LOGGER_CMP, SCATTER_GATHER_CMP, SET_PAYLOAD_CMP, LOGGER_CMP, CHOICE_CMP, SET_PAYLOAD_CMP, TRY_CMP, NOOP_CMP));
    }

    private static final class AnySubCollectionIs
    extends BaseMatcher<List<List<String>>> {
        private final List<String> expected;

        public AnySubCollectionIs(String ... expected) {
            this.expected = Arrays.asList(expected);
        }

        public boolean matches(Object o) {
            List actual = (List)o;
            return actual.stream().anyMatch(sublist -> sublist.equals(this.expected));
        }

        public void describeTo(Description description) {
            description.appendText("None of the sub collections matches the list " + this.expected.toString());
        }
    }
}

