/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.visitors;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.cfg.api.BaseChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountingVisitor extends BaseChainExecutionPathTreeVisitor {

  public int sourceCount = 0;
  public int operationCount = 0;
  public int scopeCount = 0;
  public int routerCount = 0;
  public int errorHandlerCount = 0;
  public Map<String, Integer> potentialErrorInvocations = new HashMap<>();
  public List<String> interruptedChains = new ArrayList<>();

  @Override
  public void visitSource(ChainExecutionPathTree source) {
    this.sourceCount++;
  }

  @Override
  public void visitSimpleOperation(ChainExecutionPathTree operation) {
    this.operationCount++;
  }

  @Override
  public boolean visitScope(ChainExecutionPathTree scope) {
    this.scopeCount++;
    return true;
  }

  @Override
  public boolean visitRouter(ChainExecutionPathTree router) {
    this.routerCount++;
    return true;
  }

  @Override
  public boolean errorHandlerStarted(ChainExecutionPathTree handler) {
    this.errorHandlerCount++;
    return true;
  }

  @Override
  public void errorHandlerCouldBeInvoked(ChainExecutionPathTree errorHandler, ErrorType errorType) {
    String location = errorHandler.getComponentAst().getLocation().getLocation();
    int invocations = potentialErrorInvocations.getOrDefault(location, 0);
    this.potentialErrorInvocations.put(location, invocations + 1);
  }

  @Override
  public void chainInterruptedWithError(ChainExecutionPathTree chain) {
    this.interruptedChains.add(chain.getComponentAst().getLocation().getLocation());
  }
}
